/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.multistepscc;

import com.carrotsearch.hppc.IntHashSet;
import com.carrotsearch.hppc.IntScatterSet;
import com.carrotsearch.hppc.IntSet;
import com.carrotsearch.hppc.cursors.IntCursor;
import java.util.Iterator;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphdb.Direction;

public class MultiStepTrim {
    private final Graph graph;
    private final int nodeCount;
    private final IntSet nodes;
    private final int[] inDegree;
    private final int[] outDegree;

    public MultiStepTrim(Graph graph) {
        this.graph = graph;
        this.nodeCount = Math.toIntExact(graph.nodeCount());
        this.nodes = new IntHashSet();
        this.inDegree = new int[this.nodeCount];
        this.outDegree = new int[this.nodeCount];
    }

    public IntSet compute(boolean complete) {
        this.reset();
        this.trim(complete);
        return this.nodes;
    }

    private void reset() {
        for (int i = this.nodeCount - 1; i >= 0; --i) {
            this.nodes.add(i);
            this.inDegree[i] = this.graph.degree(i, Direction.INCOMING);
            this.outDegree[i] = this.graph.degree(i, Direction.OUTGOING);
        }
    }

    private void trim(boolean complete) {
        boolean changes;
        IntScatterSet remove = new IntScatterSet();
        boolean[] filter = new boolean[]{false};
        do {
            changes = false;
            Iterator<IntCursor> it = this.nodes.iterator();
            while (it.hasNext()) {
                int node = it.next().value;
                filter[0] = false;
                if (this.inDegree[node] == 0) {
                    this.graph.forEachRelationship(node, Direction.OUTGOING, (sourceNodeId, targetNodeId, relationId) -> {
                        int n = targetNodeId;
                        this.outDegree[n] = this.outDegree[n] - 1;
                        return true;
                    });
                    filter[0] = true;
                }
                if (this.outDegree[node] == 0) {
                    this.graph.forEachRelationship(node, Direction.INCOMING, (sourceNodeId, targetNodeId, relationId) -> {
                        int n = targetNodeId;
                        this.inDegree[n] = this.inDegree[n] - 1;
                        return true;
                    });
                    filter[0] = true;
                }
                if (complete && this.inDegree[node] == 1 && this.outDegree[node] == 1) {
                    this.graph.forEachRelationship(node, Direction.OUTGOING, (sourceNodeId, targetNodeId, relationId) -> {
                        if (sourceNodeId == targetNodeId) {
                            filter[0] = true;
                            return false;
                        }
                        return false;
                    });
                }
                if (filter[0]) {
                    remove.add(node);
                }
                changes |= filter[0];
            }
            this.nodes.removeAll(remove);
        } while (changes && complete);
    }
}

