/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.multistepscc;

import com.carrotsearch.hppc.IntHashSet;
import com.carrotsearch.hppc.IntLookupContainer;
import com.carrotsearch.hppc.IntScatterSet;
import com.carrotsearch.hppc.IntSet;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.core.utils.traverse.ParallelLocalQueueBFS;
import org.neo4j.graphalgo.impl.Algorithm;
import org.neo4j.graphalgo.impl.multistepscc.AbstractMultiStepTarjan;
import org.neo4j.graphalgo.impl.multistepscc.MultiStepColoring;
import org.neo4j.graphalgo.impl.multistepscc.MultiStepFWBW;
import org.neo4j.graphalgo.impl.multistepscc.MultiStepTrim;
import org.neo4j.graphalgo.results.SCCStreamResult;
import org.neo4j.graphdb.Direction;

public class MultistepSCC
extends Algorithm<MultistepSCC> {
    private Graph graph;
    private final ParallelLocalQueueBFS traverse;
    private final MultiStepColoring coloring;
    private final int cutOff;
    private final MultiStepTrim trimming;
    private final MultiStepFWBW fwbw;
    private final AbstractMultiStepTarjan tarjan;
    private final int[] connectedComponents;
    private final int nodeCount;
    private int minSetSize;
    private int maxSetSize;
    private int setCount;

    public MultistepSCC(Graph graph, ExecutorService executorService, int concurrency, int cutOff) {
        this.graph = graph;
        this.cutOff = cutOff;
        this.trimming = new MultiStepTrim(graph);
        this.coloring = new MultiStepColoring(graph, executorService, concurrency);
        this.fwbw = new MultiStepFWBW(graph, executorService, concurrency);
        this.traverse = new ParallelLocalQueueBFS(graph, executorService, concurrency);
        this.tarjan = new AbstractMultiStepTarjan(graph){

            @Override
            public void processSCC(int root, IntHashSet connected) {
                MultistepSCC.this.processSCC(root, connected);
            }
        };
        this.nodeCount = Math.toIntExact(graph.nodeCount());
        this.connectedComponents = new int[this.nodeCount];
    }

    public MultistepSCC compute() {
        this.minSetSize = Integer.MAX_VALUE;
        this.maxSetSize = 0;
        this.setCount = 0;
        Arrays.fill(this.connectedComponents, -1);
        IntSet nodeSet = this.trimming.compute(false);
        IntSet rootSCC = this.fwbw.compute(nodeSet);
        this.processSCC(this.fwbw.getRoot(), rootSCC);
        nodeSet.removeAll((IntLookupContainer)((Object)rootSCC));
        this.coloring.compute(nodeSet);
        AtomicIntegerArray colors = this.coloring.getColors();
        this.coloring.forEachColor(color -> {
            IntSet scc = this.pred(nodeSet, colors, color);
            this.processSCC(color, scc);
            nodeSet.removeAll((IntLookupContainer)((Object)scc));
            return nodeSet.size() > this.cutOff;
        });
        this.tarjan.compute(nodeSet);
        return this;
    }

    public Stream<SCCStreamResult> resultStream() {
        return IntStream.range(0, this.nodeCount).filter(node -> this.connectedComponents[node] != -1).mapToObj(node -> new SCCStreamResult(this.graph.toOriginalNodeId(node), this.connectedComponents[node]));
    }

    public int[] getConnectedComponents() {
        return this.connectedComponents;
    }

    public int getSetCount() {
        return this.setCount;
    }

    public int getMinSetSize() {
        return this.minSetSize;
    }

    public int getMaxSetSize() {
        return this.maxSetSize;
    }

    private void processSCC(int root, IntSet elements) {
        if (elements.isEmpty()) {
            return;
        }
        this.minSetSize = Math.min(this.minSetSize, elements.size());
        this.maxSetSize = Math.max(this.maxSetSize, elements.size());
        ++this.setCount;
        elements.forEach(node -> {
            this.connectedComponents[node] = root;
        });
    }

    private IntSet pred(IntSet nodes, AtomicIntegerArray colors, int cv) {
        IntScatterSet set = new IntScatterSet();
        this.traverse.reset().bfs(cv, Direction.INCOMING, nodes::contains, node -> {
            if (colors.get(node) == cv) {
                set.add(node);
            }
        }).awaitTermination();
        return set;
    }

    @Override
    public MultistepSCC me() {
        return this;
    }

    @Override
    public MultistepSCC release() {
        this.graph = null;
        return this;
    }
}

