/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.results;

import org.neo4j.graphalgo.core.utils.ProgressTimer;

public abstract class AbstractResultBuilder<R> {
    protected long loadDuration = -1L;
    protected long evalDuration = -1L;
    protected long writeDuration = -1L;

    public AbstractResultBuilder withLoadDuration(long loadDuration) {
        this.loadDuration = loadDuration;
        return this;
    }

    public AbstractResultBuilder withEvalDuration(long evalDuration) {
        this.evalDuration = evalDuration;
        return this;
    }

    public AbstractResultBuilder withWriteDuration(long writeDuration) {
        this.writeDuration = writeDuration;
        return this;
    }

    public ProgressTimer timeLoad() {
        return ProgressTimer.start(this::withLoadDuration);
    }

    public ProgressTimer timeEval() {
        return ProgressTimer.start(this::withEvalDuration);
    }

    public ProgressTimer timeWrite() {
        return ProgressTimer.start(this::withWriteDuration);
    }

    public void timeLoad(Runnable runnable) {
        try (ProgressTimer timer = this.timeLoad();){
            runnable.run();
        }
    }

    public void timeEval(Runnable runnable) {
        try (ProgressTimer timer = this.timeEval();){
            runnable.run();
        }
    }

    public void timeWrite(Runnable runnable) {
        try (ProgressTimer timer = this.timeWrite();){
            runnable.run();
        }
    }

    public abstract R build();
}

