/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.results;

import org.neo4j.graphalgo.results.AbstractResultBuilder;

public class BetweennessCentralityProcResult {
    public final long loadMillis;
    public final long computeMillis;
    public final long writeMillis;
    public final long nodes;
    public final double minCentrality;
    public final double maxCentrality;
    public final double sumCentrality;

    private BetweennessCentralityProcResult(Long loadMillis, Long computeMillis, Long writeMillis, Long nodes, Double centralityMin, Double centralityMax, Double centralitySum) {
        this.loadMillis = loadMillis;
        this.computeMillis = computeMillis;
        this.writeMillis = writeMillis;
        this.nodes = nodes;
        this.minCentrality = centralityMin;
        this.maxCentrality = centralityMax;
        this.sumCentrality = centralitySum;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends AbstractResultBuilder<BetweennessCentralityProcResult> {
        private long nodes = 0L;
        private double centralityMin = -1.0;
        private double centralityMax = -1.0;
        private double centralitySum = -1.0;

        public Builder withNodeCount(long nodes) {
            this.nodes = nodes;
            return this;
        }

        public Builder withCentralityMin(double centralityMin) {
            this.centralityMin = centralityMin;
            return this;
        }

        public Builder withCentralityMax(double centralityMax) {
            this.centralityMax = centralityMax;
            return this;
        }

        public Builder withCentralitySum(double centralitySum) {
            this.centralitySum = centralitySum;
            return this;
        }

        @Override
        public BetweennessCentralityProcResult build() {
            return new BetweennessCentralityProcResult(this.loadDuration, this.evalDuration, this.writeDuration, this.nodes, this.centralityMin, this.centralityMax, this.centralitySum);
        }
    }
}

