/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.results;

import org.neo4j.graphalgo.core.utils.ProgressTimer;
import org.neo4j.graphalgo.results.AbstractResultBuilder;

public class DeltaSteppingProcResult {
    public final long loadDuration;
    public final long evalDuration;
    public final long writeDuration;
    public final long nodeCount;

    public DeltaSteppingProcResult(long loadDuration, long evalDuration, long writeDuration, long nodeCount) {
        this.loadDuration = loadDuration;
        this.evalDuration = evalDuration;
        this.writeDuration = writeDuration;
        this.nodeCount = nodeCount;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends AbstractResultBuilder<DeltaSteppingProcResult> {
        protected long nodeCount = 0L;

        public ProgressTimer load() {
            return ProgressTimer.start(res -> {
                this.loadDuration = res;
            });
        }

        public ProgressTimer eval() {
            return ProgressTimer.start(res -> {
                this.evalDuration = res;
            });
        }

        public ProgressTimer write() {
            return ProgressTimer.start(res -> {
                this.writeDuration = res;
            });
        }

        public Builder withNodeCount(long nodeCount) {
            this.nodeCount = nodeCount;
            return this;
        }

        @Override
        public DeltaSteppingProcResult build() {
            return new DeltaSteppingProcResult(this.loadDuration, this.evalDuration, this.writeDuration, this.nodeCount);
        }
    }
}

