/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.results;

import org.neo4j.graphalgo.results.AbstractResultBuilder;

public class LabelPropagationStats {
    public final long nodes;
    public final long iterations;
    public final long loadMillis;
    public final long computeMillis;
    public final long writeMillis;
    public final boolean write;
    public final boolean didConverge;
    public final String weightProperty;
    public final String partitionProperty;

    public LabelPropagationStats(long nodes, long iterations, long loadMillis, long computeMillis, long writeMillis, boolean write, boolean didConverge, String weightProperty, String partitionProperty) {
        this.nodes = nodes;
        this.iterations = iterations;
        this.loadMillis = loadMillis;
        this.computeMillis = computeMillis;
        this.writeMillis = writeMillis;
        this.write = write;
        this.didConverge = didConverge;
        this.weightProperty = weightProperty;
        this.partitionProperty = partitionProperty;
    }

    public static class Builder
    extends AbstractResultBuilder<LabelPropagationStats> {
        private long nodes = 0L;
        private long iterations = 0L;
        private boolean didConverge = false;
        private boolean write;
        private String weightProperty;
        private String partitionProperty;

        public Builder nodes(long nodes) {
            this.nodes = nodes;
            return this;
        }

        public Builder iterations(long iterations) {
            this.iterations = iterations;
            return this;
        }

        public Builder didConverge(boolean didConverge) {
            this.didConverge = didConverge;
            return this;
        }

        public Builder write(boolean write) {
            this.write = write;
            return this;
        }

        public Builder weightProperty(String weightProperty) {
            this.weightProperty = weightProperty;
            return this;
        }

        public Builder partitionProperty(String partitionProperty) {
            this.partitionProperty = partitionProperty;
            return this;
        }

        @Override
        public LabelPropagationStats build() {
            return new LabelPropagationStats(this.nodes, this.iterations, this.loadDuration, this.evalDuration, this.writeDuration, this.write, this.didConverge, this.weightProperty, this.partitionProperty);
        }
    }
}

