/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.results;

import org.neo4j.graphalgo.results.AbstractResultBuilder;
import org.neo4j.graphdb.Node;

public class PageRankScore {
    public final Node node;
    public final Double score;

    public PageRankScore(Node node, Double score) {
        this.node = node;
        this.score = score;
    }

    public static final class Stats {
        public final long nodes;
        public final long iterations;
        public final long loadMillis;
        public final long computeMillis;
        public final long writeMillis;
        public final double dampingFactor;
        public final boolean write;
        public final String writeProperty;

        Stats(long nodes, long iterations, long loadMillis, long computeMillis, long writeMillis, double dampingFactor, boolean write, String writeProperty) {
            this.nodes = nodes;
            this.iterations = iterations;
            this.loadMillis = loadMillis;
            this.computeMillis = computeMillis;
            this.writeMillis = writeMillis;
            this.dampingFactor = dampingFactor;
            this.write = write;
            this.writeProperty = writeProperty;
        }

        public static final class Builder
        extends AbstractResultBuilder<Stats> {
            private long nodes;
            private long iterations;
            private double dampingFactor;
            private boolean write;
            private String writeProperty;

            public Builder withNodes(long nodes) {
                this.nodes = nodes;
                return this;
            }

            public Builder withIterations(long iterations) {
                this.iterations = iterations;
                return this;
            }

            public Builder withDampingFactor(double dampingFactor) {
                this.dampingFactor = dampingFactor;
                return this;
            }

            public Builder withWrite(boolean write) {
                this.write = write;
                return this;
            }

            public Builder withProperty(String writeProperty) {
                this.writeProperty = writeProperty;
                return this;
            }

            @Override
            public Stats build() {
                return new Stats(this.nodes, this.iterations, this.loadDuration, this.evalDuration, this.writeDuration, this.dampingFactor, this.write, this.writeProperty);
            }
        }
    }
}

