/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.StubPageCursor;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;

public class StubPagedFile
implements PagedFile {
    private final int pageSize;
    public final int exposedPageSize;
    public long lastPageId = 1L;

    public StubPagedFile(int pageSize) {
        this.pageSize = pageSize;
        this.exposedPageSize = pageSize;
    }

    public PageCursor io(long pageId, int pf_flags, PageCursorTracer tracer) throws IOException {
        StubPageCursor cursor = new StubPageCursor(pageId, this.pageSize);
        this.prepareCursor(cursor);
        return cursor;
    }

    protected void prepareCursor(StubPageCursor cursor) {
    }

    public int pageSize() {
        return this.exposedPageSize;
    }

    public long fileSize() {
        if (this.lastPageId < 0L) {
            return 0L;
        }
        return (this.lastPageId + 1L) * (long)this.pageSize();
    }

    public Path path() {
        return Path.of("stub", new String[0]);
    }

    public void flushAndForce() {
    }

    public void flushAndForce(IOLimiter limiter) {
    }

    public long getLastPageId() {
        return this.lastPageId;
    }

    public void close() {
    }

    public void setDeleteOnClose(boolean deleteOnClose) {
    }

    public boolean isDeleteOnClose() {
        return false;
    }

    public Optional<String> getDatabaseName() {
        return Optional.empty();
    }
}

