/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.rule.fs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.junit.rules.ExternalResource;
import org.neo4j.io.fs.FileHandle;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.fs.watcher.FileWatcher;

public abstract class FileSystemRule<FS extends FileSystemAbstraction>
extends ExternalResource
implements FileSystemAbstraction,
Supplier<FileSystemAbstraction> {
    protected volatile FS fs;

    protected FileSystemRule(FS fs) {
        this.fs = fs;
    }

    protected void after() {
        try {
            this.fs.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        super.after();
    }

    @Override
    public FS get() {
        return this.fs;
    }

    public void close() throws IOException {
        this.fs.close();
    }

    public FileWatcher fileWatcher() throws IOException {
        return this.fs.fileWatcher();
    }

    public StoreChannel open(Path fileName, Set<OpenOption> options) throws IOException {
        return this.fs.open(fileName, options);
    }

    public OutputStream openAsOutputStream(Path fileName, boolean append) throws IOException {
        return this.fs.openAsOutputStream(fileName, append);
    }

    public InputStream openAsInputStream(Path fileName) throws IOException {
        return this.fs.openAsInputStream(fileName);
    }

    public Reader openAsReader(Path fileName, Charset charset) throws IOException {
        return this.fs.openAsReader(fileName, charset);
    }

    public Writer openAsWriter(Path fileName, Charset charset, boolean append) throws IOException {
        return this.fs.openAsWriter(fileName, charset, append);
    }

    public StoreChannel write(Path fileName) throws IOException {
        return this.fs.write(fileName);
    }

    public StoreChannel read(Path fileName) throws IOException {
        return this.fs.read(fileName);
    }

    public boolean fileExists(Path file) {
        return this.fs.fileExists(file);
    }

    public boolean mkdir(Path fileName) {
        return this.fs.mkdir(fileName);
    }

    public void mkdirs(Path fileName) throws IOException {
        this.fs.mkdirs(fileName);
    }

    public long getFileSize(Path fileName) {
        return this.fs.getFileSize(fileName);
    }

    public boolean deleteFile(Path fileName) {
        return this.fs.deleteFile(fileName);
    }

    public void deleteRecursively(Path directory) throws IOException {
        this.fs.deleteRecursively(directory);
    }

    public void renameFile(Path from, Path to, CopyOption ... copyOptions) throws IOException {
        this.fs.renameFile(from, to, copyOptions);
    }

    public Path[] listFiles(Path directory) {
        return this.fs.listFiles(directory);
    }

    public Path[] listFiles(Path directory, DirectoryStream.Filter<Path> filter) {
        return this.fs.listFiles(directory, filter);
    }

    public boolean isDirectory(Path file) {
        return this.fs.isDirectory(file);
    }

    public void moveToDirectory(Path file, Path toDirectory) throws IOException {
        this.fs.moveToDirectory(file, toDirectory);
    }

    public void copyToDirectory(Path file, Path toDirectory) throws IOException {
        this.fs.copyToDirectory(file, toDirectory);
    }

    public void copyFile(Path from, Path to) throws IOException {
        this.fs.copyFile(from, to);
    }

    public void copyFile(Path from, Path to, CopyOption ... copyOptions) throws IOException {
        this.fs.copyFile(from, to, copyOptions);
    }

    public void copyRecursively(Path fromDirectory, Path toDirectory) throws IOException {
        this.fs.copyRecursively(fromDirectory, toDirectory);
    }

    public void truncate(Path path, long size) throws IOException {
        this.fs.truncate(path, size);
    }

    public long lastModifiedTime(Path file) {
        return this.fs.lastModifiedTime(file);
    }

    public void deleteFileOrThrow(Path file) throws IOException {
        this.fs.deleteFileOrThrow(file);
    }

    public Stream<FileHandle> streamFilesRecursive(Path directory) throws IOException {
        return this.fs.streamFilesRecursive(directory);
    }

    public int getFileDescriptor(StoreChannel channel) {
        return this.fs.getFileDescriptor(channel);
    }

    public int hashCode() {
        return this.fs.hashCode();
    }

    public boolean equals(Object obj) {
        return this.fs.equals(obj);
    }

    public String toString() {
        return this.fs.toString();
    }

    public long getBlockSize(Path file) throws IOException {
        return this.fs.getBlockSize(file);
    }
}

