/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.utils;

import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.ObjectUtils;
import org.neo4j.adversaries.Adversary;
import org.neo4j.adversaries.pagecache.AdversarialPageCache;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.mem.MemoryAllocator;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.checking.AccessCheckingPageCache;
import org.neo4j.io.pagecache.impl.SingleFilePageSwapperFactory;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.scheduler.ThreadPoolJobScheduler;
import org.neo4j.test.utils.PageCacheConfig;
import org.neo4j.time.Clocks;
import org.neo4j.time.SystemNanoClock;

public class PageCacheSupport {
    protected JobScheduler jobScheduler;
    protected SystemNanoClock clock;
    protected PageCache pageCache;
    private final PageCacheConfig baseConfig;

    public PageCacheSupport() {
        this(PageCacheConfig.config());
    }

    public PageCacheSupport(PageCacheConfig config) {
        this.baseConfig = config;
    }

    public PageCache getPageCache(FileSystemAbstraction fs) {
        return this.getPageCache(fs, PageCacheConfig.config());
    }

    public PageCache getPageCache(FileSystemAbstraction fs, PageCacheConfig overriddenConfig) {
        SingleFilePageSwapperFactory factory = new SingleFilePageSwapperFactory(fs, (PageCacheTracer)new DefaultPageCacheTracer());
        return this.getPageCache((PageSwapperFactory)factory, overriddenConfig);
    }

    public PageCache getPageCache(PageSwapperFactory swapperFactory) {
        return this.getPageCache(swapperFactory, PageCacheConfig.config());
    }

    public PageCache getPageCache(PageSwapperFactory factory, PageCacheConfig overriddenConfig) {
        this.closeExistingPageCache();
        LocalMemoryTracker memoryTracker = new LocalMemoryTracker();
        MemoryAllocator mman = MemoryAllocator.createAllocator((long)ByteUnit.parse((String)PageCacheSupport.selectConfig(this.baseConfig.memory, overriddenConfig.memory, "8 MiB")), (MemoryTracker)memoryTracker);
        if (this.clock == null) {
            this.clock = Clocks.nanoClock();
        }
        MuninnPageCache.Configuration configuration = MuninnPageCache.config((MemoryAllocator)mman).memoryTracker((MemoryTracker)memoryTracker).clock(this.clock);
        Integer pageSize = PageCacheSupport.selectConfig(this.baseConfig.pageSize, overriddenConfig.pageSize, null);
        configuration = pageSize == null ? configuration : configuration.pageSize(pageSize.intValue());
        PageCacheTracer cacheTracer = PageCacheSupport.selectConfig(this.baseConfig.tracer, overriddenConfig.tracer, PageCacheTracer.NULL);
        configuration = configuration.pageCacheTracer(cacheTracer);
        this.initializeJobScheduler();
        this.pageCache = new MuninnPageCache(factory, this.jobScheduler, configuration);
        this.pageCachePostConstruct(overriddenConfig);
        return this.pageCache;
    }

    protected void initializeJobScheduler() {
        this.jobScheduler = new ThreadPoolJobScheduler("PageCacheRule-");
    }

    protected static <T> T selectConfig(T base, T overridden, T defaultValue) {
        return (T)ObjectUtils.firstNonNull((Object[])new Object[]{base, overridden, defaultValue});
    }

    protected void pageCachePostConstruct(PageCacheConfig overriddenConfig) {
        if (PageCacheSupport.selectConfig(this.baseConfig.inconsistentReads, overriddenConfig.inconsistentReads, Boolean.TRUE).booleanValue()) {
            AtomicBoolean controller = PageCacheSupport.selectConfig(this.baseConfig.nextReadIsInconsistent, overriddenConfig.nextReadIsInconsistent, null);
            Adversary adversary = controller != null ? new AtomicBooleanInconsistentReadAdversary(controller) : new RandomInconsistentReadAdversary();
            this.pageCache = new AdversarialPageCache(this.pageCache, adversary);
        }
        if (PageCacheSupport.selectConfig(this.baseConfig.accessChecks, overriddenConfig.accessChecks, false).booleanValue()) {
            this.pageCache = new AccessCheckingPageCache(this.pageCache);
        }
    }

    protected void closeExistingPageCache() {
        this.closePageCache("Failed to stop existing PageCache prior to creating a new one.");
        this.closeJobScheduler("Failed to stop existing job scheduler prior to creating a new one.");
    }

    protected void after(boolean success) {
        this.closePageCache("Failed to stop PageCache after test.");
        this.closeJobScheduler("Failed to stop job scheduler after test.");
    }

    private void closeJobScheduler(String errorMessage) {
        if (this.jobScheduler != null) {
            try {
                this.jobScheduler.close();
            }
            catch (Exception e) {
                throw new RuntimeException(errorMessage, e);
            }
            this.jobScheduler = null;
        }
    }

    private void closePageCache(String errorMessage) {
        if (this.pageCache != null) {
            try {
                this.pageCache.close();
            }
            catch (Exception e) {
                throw new AssertionError(errorMessage, e);
            }
            this.pageCache = null;
        }
    }

    private static class RandomInconsistentReadAdversary
    implements Adversary {
        private RandomInconsistentReadAdversary() {
        }

        @Override
        @SafeVarargs
        public final void injectFailure(Class<? extends Throwable> ... failureTypes) {
        }

        @Override
        @SafeVarargs
        public final boolean injectFailureOrMischief(Class<? extends Throwable> ... failureTypes) {
            return ThreadLocalRandom.current().nextBoolean();
        }

        @Override
        public Optional<Throwable> getLastAdversaryException() {
            return Optional.empty();
        }
    }

    public static class AtomicBooleanInconsistentReadAdversary
    implements Adversary {
        final AtomicBoolean nextReadIsInconsistent;

        public AtomicBooleanInconsistentReadAdversary(AtomicBoolean nextReadIsInconsistent) {
            this.nextReadIsInconsistent = nextReadIsInconsistent;
        }

        @Override
        @SafeVarargs
        public final void injectFailure(Class<? extends Throwable> ... failureTypes) {
        }

        @Override
        @SafeVarargs
        public final boolean injectFailureOrMischief(Class<? extends Throwable> ... failureTypes) {
            return this.nextReadIsInconsistent.getAndSet(false);
        }

        @Override
        public Optional<Throwable> getLastAdversaryException() {
            return Optional.empty();
        }
    }
}

