/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.fs;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.memory.ByteBuffers;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.FeatureToggles;
import org.neo4j.util.Preconditions;

class EphemeralDynamicByteBuffer {
    private static final boolean TRACE_BUFFER_FREE = FeatureToggles.flag(EphemeralDynamicByteBuffer.class, (String)"TRACE_BUFFER_FREE", (boolean)false);
    private static final Exception PLACEHOLDER_EXCEPTION = new Exception("Enable " + EphemeralDynamicByteBuffer.class.getName() + ".TRACE_BUFFER_FREE flag to see actual stacktrace");
    private static final int SECTOR_SIZE = (int)ByteUnit.kibiBytes((long)1L);
    private static final byte[] ZERO_BUFFER_ARRAY = new byte[SECTOR_SIZE];
    private final ByteBuffer zeroBuffer = ByteBuffer.wrap(ZERO_BUFFER_ARRAY);
    private SortedMap<Long, ByteBuffer> sectors = new TreeMap<Long, ByteBuffer>();
    private Exception freeCall;
    private long size;

    EphemeralDynamicByteBuffer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EphemeralDynamicByteBuffer(EphemeralDynamicByteBuffer toClone) {
        this();
        EphemeralDynamicByteBuffer ephemeralDynamicByteBuffer = toClone;
        synchronized (ephemeralDynamicByteBuffer) {
            toClone.assertNotFreed();
            for (Map.Entry<Long, ByteBuffer> entry : toClone.sectors.entrySet()) {
                ByteBuffer sector = EphemeralDynamicByteBuffer.newSector();
                EphemeralDynamicByteBuffer.copyByteBufferContents(entry.getValue(), sector);
                this.sectors.put(entry.getKey(), sector);
            }
            this.size = toClone.getSize();
        }
    }

    synchronized EphemeralDynamicByteBuffer copy() {
        return new EphemeralDynamicByteBuffer(this);
    }

    synchronized void free() {
        this.assertNotFreed();
        this.sectors = null;
        this.freeCall = TRACE_BUFFER_FREE ? new Exception("You're most likely seeing this exception because there was an attempt to use this buffer after it was freed. This stack trace may help you figure out where and why it was freed.") : PLACEHOLDER_EXCEPTION;
    }

    synchronized void put(long pos, byte[] bytes, int off, int length) {
        long sector = pos / (long)SECTOR_SIZE;
        int offset = (int)(pos % (long)SECTOR_SIZE);
        this.size = Math.max(this.size, pos + (long)length);
        while (true) {
            ByteBuffer buf = this.getOrCreateSector(sector);
            buf.position(offset);
            int toPut = Math.min(buf.remaining(), length);
            buf.put(bytes, off, toPut);
            if (toPut == length) break;
            off += toPut;
            length -= toPut;
            offset = 0;
            ++sector;
        }
    }

    synchronized void get(long pos, byte[] bytes, int off, int length) {
        long sector = pos / (long)SECTOR_SIZE;
        int offset = (int)(pos % (long)SECTOR_SIZE);
        while (true) {
            ByteBuffer buf = this.sectors.getOrDefault(sector, this.zeroBuffer);
            buf.position(offset);
            int toGet = Math.min(buf.remaining(), length);
            buf.get(bytes, off, toGet);
            if (toGet == length) break;
            off += toGet;
            length -= toGet;
            offset = 0;
            ++sector;
        }
    }

    synchronized long getSize() {
        return this.size;
    }

    synchronized void truncate(long newSize) {
        Preconditions.requireNonNegative((long)newSize);
        this.size = newSize;
        SortedMap<Long, ByteBuffer> tail = this.sectors.tailMap(newSize - (long)(SECTOR_SIZE - 1));
        if (tail.isEmpty()) {
            return;
        }
        Long firstKey = tail.firstKey();
        if (firstKey <= newSize) {
            ByteBuffer buffer = (ByteBuffer)tail.get(firstKey);
            int tailToClear = Math.toIntExact(newSize - firstKey);
            buffer.position(tailToClear);
            while (buffer.hasRemaining()) {
                buffer.put((byte)0);
            }
        }
        this.sectors.tailMap(firstKey + 1L).clear();
    }

    private static void copyByteBufferContents(ByteBuffer from, ByteBuffer to) {
        int positionBefore = from.position();
        try {
            from.position(0);
            to.put(from);
        }
        finally {
            from.position(positionBefore);
            to.position(0);
        }
    }

    private static ByteBuffer newSector() {
        return ByteBuffers.allocate((int)SECTOR_SIZE, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
    }

    private synchronized ByteBuffer getOrCreateSector(long sector) {
        ByteBuffer buf = (ByteBuffer)this.sectors.get(sector);
        if (buf == null) {
            buf = EphemeralDynamicByteBuffer.newSector();
            this.sectors.put(sector, buf);
        }
        return buf;
    }

    private synchronized void assertNotFreed() {
        if (this.sectors == null) {
            throw new IllegalStateException("This buffer has been freed.", this.freeCall);
        }
    }
}

