/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Clock;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import org.apache.commons.codec.digest.DigestUtils;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileHandle;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.util.VisibleForTesting;

public class TestDirectory {
    private static final LocalDateTime now = LocalDateTime.now(Clock.systemUTC());
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("dd_HH-mm-ss-SSS").withZone(ZoneOffset.UTC);
    public static final String REGISTER_FILE_NAME = ".register";
    private final FileSystemAbstraction fileSystem;
    private Path testClassBaseFolder;
    private Class<?> owningTest;
    private boolean keepDirectoryAfterSuccessfulTest;
    private Path directory;
    private int additionalRefs;
    private boolean anyFailure;

    private TestDirectory(FileSystemAbstraction fileSystem) {
        this.fileSystem = fileSystem;
    }

    private TestDirectory(FileSystemAbstraction fileSystem, Class<?> owningTest) {
        this.fileSystem = fileSystem;
        this.owningTest = owningTest;
    }

    public static TestDirectory testDirectory() {
        return new TestDirectory((FileSystemAbstraction)new DefaultFileSystemAbstraction());
    }

    public static TestDirectory testDirectory(FileSystemAbstraction fs) {
        return new TestDirectory(fs);
    }

    public static TestDirectory testDirectory(Class<?> owningTest) {
        return new TestDirectory((FileSystemAbstraction)new DefaultFileSystemAbstraction(), owningTest);
    }

    public static TestDirectory testDirectory(Class<?> owningTest, FileSystemAbstraction fs) {
        return new TestDirectory(fs, owningTest);
    }

    public TestDirectory keepDirectoryAfterSuccessfulTest() {
        this.keepDirectoryAfterSuccessfulTest = true;
        return this;
    }

    public Path absolutePath() {
        return this.homePath().toAbsolutePath();
    }

    public Path homePath() {
        if (!this.isInitialised()) {
            throw new IllegalStateException("Not initialized");
        }
        return this.directory;
    }

    public Path homePath(String homeDirName) {
        return this.directory(homeDirName);
    }

    public boolean isInitialised() {
        return this.directory != null;
    }

    public Path cleanDirectory(String name) throws IOException {
        return TestDirectory.clean(this.fileSystem, this.directory(name));
    }

    public Path directory(String name) {
        Path dir = this.homePath().resolve(name);
        this.createDirectory(dir);
        return dir;
    }

    public Path cleanDirectory(String name, String ... path) throws IOException {
        return TestDirectory.clean(this.fileSystem, this.directory(name, path));
    }

    public Path directory(String name, String ... path) {
        Path dir = this.homePath();
        for (String s : path) {
            dir = dir.resolve(s);
        }
        dir = dir.resolve(name);
        this.createDirectory(dir);
        return dir;
    }

    public Path file(String name) {
        return this.homePath().resolve(name);
    }

    public Path file(String name, String ... path) {
        Path dir = this.homePath();
        for (String s : path) {
            dir = dir.resolve(s);
        }
        return dir.resolve(name);
    }

    public Path createFile(String name) {
        Path file = this.file(name);
        this.ensureFileExists(file);
        return file;
    }

    public void cleanup() throws IOException {
        TestDirectory.clean(this.fileSystem, this.testClassBaseFolder);
    }

    public String toString() {
        String testDirectoryName = this.isInitialised() ? this.directory.toString() : "<uninitialized>";
        return String.format("%s[\"%s\"]", this.getClass().getSimpleName(), testDirectoryName);
    }

    private Path cleanBaseDirectory(String name) throws IOException {
        return TestDirectory.clean(this.fileSystem, this.ensureBase().resolve(name));
    }

    public void complete(boolean success) throws IOException {
        this.anyFailure |= !success;
        if (this.isInitialised()) {
            if (this.additionalRefs > 0) {
                --this.additionalRefs;
                return;
            }
            Path directory = this.directory;
            this.directory = null;
            if (!this.anyFailure && !this.keepDirectoryAfterSuccessfulTest) {
                this.fileSystem.deleteRecursively(directory);
            } else if (!this.fileSystem.isPersistent()) {
                for (FileHandle fh : (FileHandle[])this.fileSystem.streamFilesRecursive(directory).toArray(FileHandle[]::new)) {
                    Path path = fh.getPath();
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    try (InputStream inputStream = this.fileSystem.openAsInputStream(path);){
                        Files.copy(inputStream, path, StandardCopyOption.REPLACE_EXISTING);
                    }
                }
            }
        }
    }

    public void close() throws IOException {
        block7: {
            if (this.isInitialised()) {
                return;
            }
            try {
                if (this.testClassBaseFolder == null || !Files.exists(this.testClassBaseFolder, new LinkOption[0])) break block7;
                try {
                    Path[] files = this.fileSystem.listFiles(this.testClassBaseFolder);
                    if (files != null && files.length == 1 && files[0].getFileName().toString().equals(REGISTER_FILE_NAME)) {
                        this.fileSystem.deleteRecursively(this.testClassBaseFolder);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            finally {
                this.fileSystem.close();
            }
        }
    }

    public void prepareDirectory(Class<?> testClass, String test) throws IOException {
        if (this.isInitialised()) {
            ++this.additionalRefs;
            return;
        }
        if (this.owningTest == null) {
            this.owningTest = testClass;
        }
        if (test == null) {
            test = "static";
        }
        this.directory = this.prepareDirectoryForTest(test);
    }

    public Path prepareDirectoryForTest(String test) throws IOException {
        String dir = this.getDateTime() + "_" + DigestUtils.md5Hex((String)test).substring(0, 5);
        this.evaluateClassBaseTestFolder();
        this.register(test, dir);
        return this.cleanBaseDirectory(dir);
    }

    private String getDateTime() {
        return DATE_TIME_FORMATTER.format(now);
    }

    @VisibleForTesting
    public FileSystemAbstraction getFileSystem() {
        return this.fileSystem;
    }

    private void ensureFileExists(Path file) {
        try {
            if (!this.fileSystem.fileExists(file)) {
                this.fileSystem.write(file).close();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to create file: " + String.valueOf(file), e);
        }
    }

    private void createDirectory(Path directory) {
        try {
            this.fileSystem.mkdirs(directory);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to create directory: " + String.valueOf(directory), e);
        }
    }

    private static Path clean(FileSystemAbstraction fs, Path dir) throws IOException {
        if (fs.fileExists(dir)) {
            fs.deleteRecursively(dir);
        }
        fs.mkdirs(dir);
        return dir;
    }

    private void evaluateClassBaseTestFolder() {
        if (this.owningTest == null) {
            throw new IllegalStateException(" Test owning class is not defined");
        }
        this.testClassBaseFolder = TestDirectory.testDataDirectoryOf(this.owningTest);
    }

    private static Path testDataDirectoryOf(Class<?> owningTest) {
        Path testData = TestDirectory.locateTarget(owningTest).resolve("test data");
        return testData.resolve(TestDirectory.shorten(owningTest.getName())).toAbsolutePath();
    }

    private static String shorten(String owningTestName) {
        int targetPartLength = 5;
        CharSequence[] parts = owningTestName.split("\\.");
        for (int i = 0; i < parts.length - 1; ++i) {
            String part = parts[i];
            if (part.length() <= targetPartLength) continue;
            parts[i] = part.substring(0, targetPartLength - 1) + "~";
        }
        return String.join((CharSequence)".", parts);
    }

    private void register(String test, String dir) {
        try (PrintStream printStream = new PrintStream(this.fileSystem.openAsOutputStream(this.ensureBase().resolve(REGISTER_FILE_NAME), true), false, StandardCharsets.UTF_8);){
            printStream.print(String.format("%s = %s%n", dir, test));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Path ensureBase() {
        if (this.testClassBaseFolder == null) {
            this.evaluateClassBaseTestFolder();
        }
        if (this.fileSystem.fileExists(this.testClassBaseFolder) && !this.fileSystem.isDirectory(this.testClassBaseFolder)) {
            throw new IllegalStateException(String.valueOf(this.testClassBaseFolder) + " exists and is not a directory!");
        }
        try {
            this.fileSystem.mkdirs(this.testClassBaseFolder);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.testClassBaseFolder;
    }

    private static Path locateTarget(Class<?> owningTest) {
        try {
            Path codeSource = Path.of(owningTest.getProtectionDomain().getCodeSource().getLocation().toURI());
            if (Files.isDirectory(codeSource, new LinkOption[0])) {
                return codeSource.getParent();
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return Path.of("target", new String[0]);
    }
}

