/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Throwables;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.time.Stopwatch;

public class LogAssert
extends AbstractAssert<LogAssert, AssertableLogProvider> {
    private Class<?> loggerClazz;
    private AssertableLogProvider.Level logLevel;

    public LogAssert(AssertableLogProvider logProvider) {
        super((Object)logProvider, LogAssert.class);
    }

    public LogAssert forClass(Class<?> clazz) {
        this.loggerClazz = clazz;
        return this;
    }

    public LogAssert forLevel(AssertableLogProvider.Level level) {
        this.logLevel = level;
        return this;
    }

    public LogAssert containsMessages(String ... messages) {
        this.isNotNull();
        for (String message : messages) {
            if (this.haveMessage(message)) continue;
            this.failWithMessage("Expected log to contain messages: `%s` but no matches found in:%n%s", new Object[]{Arrays.toString(messages), ((AssertableLogProvider)((Object)this.actual)).serialize()});
        }
        return this;
    }

    public LogAssert containsMessagesEventually(long maxWaitTimeoutMs, String ... messages) throws InterruptedException {
        this.isNotNull();
        Stopwatch stopwatch = Stopwatch.start();
        for (String message : messages) {
            while (!this.haveMessage(message)) {
                if (stopwatch.hasTimedOut(maxWaitTimeoutMs, TimeUnit.MILLISECONDS)) {
                    this.failWithMessage("Expected log to contain messages: `%s` but no matches found in:%n%s", new Object[]{Arrays.toString(messages), ((AssertableLogProvider)((Object)this.actual)).serialize()});
                }
                Thread.sleep(10L);
            }
        }
        return this;
    }

    public LogAssert containsAtLeastMessageCountEventually(long maxWaitTimeoutMs, String message, int expectedCount) throws InterruptedException {
        this.isNotNull();
        Stopwatch stopwatch = Stopwatch.start();
        long actualCount = this.messageMatchCount(message);
        while (actualCount < (long)expectedCount) {
            if (stopwatch.hasTimedOut(maxWaitTimeoutMs, TimeUnit.MILLISECONDS)) {
                this.failWithMessage("Expected log to contain %s of message: `%s` but only %s matches found in:%n%s", new Object[]{expectedCount, message, actualCount, ((AssertableLogProvider)((Object)this.actual)).serialize()});
            }
            Thread.sleep(10L);
            actualCount = this.messageMatchCount(message);
        }
        return this;
    }

    public LogAssert containsMessages(Predicate<String> predicate) {
        this.isNotNull();
        if (!this.haveMessage(predicate)) {
            this.failWithMessage("Expected log to contain messages: `%s` but no matches found in:%n%s", new Object[]{predicate, ((AssertableLogProvider)((Object)this.actual)).serialize()});
        }
        return this;
    }

    public final LogAssert containsMessages(final Pattern pattern, final Predicate<String> ... valueTests) {
        this.isNotNull();
        Predicate<String> predicate = new Predicate<String>(){

            @Override
            public boolean test(String s) {
                Matcher matcher = pattern.matcher(s);
                while (matcher.find()) {
                    if (!this.matchesExpectedValues(matcher)) continue;
                    return true;
                }
                return false;
            }

            private boolean matchesExpectedValues(Matcher matcher) {
                int groupCount = matcher.groupCount();
                for (int i = 0; i < groupCount && i < valueTests.length; ++i) {
                    if (valueTests[i].test(matcher.group(1 + i))) continue;
                    return false;
                }
                return true;
            }

            public String toString() {
                return String.format("Pattern:%s, valueTests:%s", pattern.pattern(), Arrays.toString(valueTests));
            }
        };
        return this.containsMessages(predicate);
    }

    public LogAssert containsMessagesInOrder(String ... messages) {
        this.isNotNull();
        int prevIndex = -1;
        for (String message : messages) {
            int index = this.messageIndex(message, prevIndex);
            if (index < 0) {
                if (!this.haveMessage(message)) {
                    this.failWithMessage("Expected log to contain messages: `%s` but no matches found in:%n%s", new Object[]{Arrays.toString(messages), ((AssertableLogProvider)((Object)this.actual)).serialize()});
                } else {
                    this.failWithMessage("Expected log to contain: `%s` in order `%s` but was not matching:%n%s", new Object[]{message, Arrays.toString(messages), ((AssertableLogProvider)((Object)this.actual)).serialize()});
                }
            }
            prevIndex = index;
        }
        return this;
    }

    public LogAssert containsMessagesOnce(String ... messages) {
        this.isNotNull();
        for (String message : messages) {
            long messageMatchCount = this.messageMatchCount(message);
            if (messageMatchCount == 1L) continue;
            if (messageMatchCount == 0L) {
                this.failWithMessage("Expected log to contain messages: `%s` exactly once but no matches found in:%n%s", new Object[]{Arrays.toString(messages), ((AssertableLogProvider)((Object)this.actual)).serialize()});
                continue;
            }
            this.failWithMessage("Expected log to contain messages: `%s` exactly once but %d matches found in:%n%s", new Object[]{Arrays.toString(messages), messageMatchCount, ((AssertableLogProvider)((Object)this.actual)).serialize()});
        }
        return this;
    }

    public AbstractLongAssert messageCount(String ... messages) {
        return Assertions.assertThat((long)Stream.of(messages).mapToLong(this::messageMatchCount).sum());
    }

    public LogAssert doesNotHaveAnyLogs() {
        this.isNotNull();
        if (((AssertableLogProvider)((Object)this.actual)).getLogCalls().stream().anyMatch(call -> this.matchedLogger((AssertableLogProvider.LogCall)call) && this.matchedLevel((AssertableLogProvider.LogCall)call))) {
            this.failWithMessage("Expected log to be empty but following log calls were recorded:%n%s", new Object[]{((AssertableLogProvider)((Object)this.actual)).serialize()});
        }
        return this;
    }

    public LogAssert doesNotContainMessage(String message) {
        this.isNotNull();
        if (this.haveMessage(message)) {
            this.failWithMessage("Unexpected log message: `%s` in:%n%s", new Object[]{message, ((AssertableLogProvider)((Object)this.actual)).serialize()});
        }
        return this;
    }

    public LogAssert onlyContainsMessages(String ... messages) {
        this.isNotNull();
        if (!((AssertableLogProvider)((Object)this.actual)).getLogCalls().stream().filter(call -> this.matchedLogger((AssertableLogProvider.LogCall)call) && this.matchedLevel((AssertableLogProvider.LogCall)call)).allMatch(call -> Stream.of(messages).anyMatch(message -> LogAssert.matchedMessage(message, call)))) {
            this.failWithMessage("Expected log to only contain messages:%n%s%nbut found:%n%s", new Object[]{Arrays.toString(messages), ((AssertableLogProvider)((Object)this.actual)).serialize()});
        }
        return this;
    }

    public LogAssert containsMessageWithArguments(String message, Object ... arguments) {
        this.isNotNull();
        if (!this.haveMessageWithArguments(message, arguments)) {
            this.failWithMessage("Expected log to contain messages: `%s` with arguments: `%s`. But no matches found in:%n%s", new Object[]{message, Arrays.toString(arguments), ((AssertableLogProvider)((Object)this.actual)).serialize()});
        }
        return this;
    }

    public LogAssert containsMessageWithArgumentsContaining(String message, Object ... arguments) {
        this.isNotNull();
        if (!this.haveMessageWithArgumentsContaining(message, arguments)) {
            this.failWithMessage("Expected log to contain messages: `%s` with arguments containing: `%s`. But no matches found in:%n%s", new Object[]{message, Arrays.toString(arguments), ((AssertableLogProvider)((Object)this.actual)).serialize()});
        }
        return this;
    }

    public LogAssert containsMessageWithArgumentsMatching(String message, Predicate<Object[]> argumentMatcher) {
        this.isNotNull();
        if (!this.haveMessageWithArgumentsMatching(message, argumentMatcher)) {
            this.failWithMessage("Expected log to contain messages: `%s` with arguments matching predicate. But no matches found in:%n%s", new Object[]{message, ((AssertableLogProvider)((Object)this.actual)).serialize()});
        }
        return this;
    }

    public LogAssert doesNotContainMessageWithArguments(String message, Object ... arguments) {
        this.isNotNull();
        if (this.haveMessageWithArguments(message, arguments)) {
            this.failWithMessage("Unexpected log message: `%s` with arguments: `%s`  in:%n%s", new Object[]{message, Arrays.toString(arguments), ((AssertableLogProvider)((Object)this.actual)).serialize()});
        }
        return this;
    }

    public LogAssert containsMessageWithAll(String ... snippets) {
        this.isNotNull();
        Queue<AssertableLogProvider.LogCall> logCalls = ((AssertableLogProvider)((Object)this.actual)).getLogCalls();
        boolean matched = logCalls.stream().anyMatch(call -> this.matchedLogger((AssertableLogProvider.LogCall)call) && this.matchedLevel((AssertableLogProvider.LogCall)call) && Arrays.stream(snippets).allMatch(snippet -> LogAssert.matchedMessage(snippet, call)));
        if (!matched) {
            this.failWithMessage("Expected log to contain a message containing: `%s`. But no matches found in:%s", new Object[]{Arrays.toString(snippets), ((AssertableLogProvider)((Object)this.actual)).serialize()});
        }
        return this;
    }

    public LogAssert containsMessageWithAllOnce(String ... snippets) {
        boolean matched;
        this.isNotNull();
        Queue<AssertableLogProvider.LogCall> logCalls = ((AssertableLogProvider)((Object)this.actual)).getLogCalls();
        boolean bl = matched = logCalls.stream().filter(call -> this.matchedLogger((AssertableLogProvider.LogCall)call) && this.matchedLevel((AssertableLogProvider.LogCall)call) && Arrays.stream(snippets).allMatch(snippet -> LogAssert.matchedMessage(snippet, call))).count() == 1L;
        if (!matched) {
            this.failWithMessage("Expected log to contain a message containing: `%s`. But more than one matches found in:%s", new Object[]{Arrays.toString(snippets), ((AssertableLogProvider)((Object)this.actual)).serialize()});
        }
        return this;
    }

    public LogAssert eachMessageContains(String message) {
        this.isNotNull();
        for (AssertableLogProvider.LogCall logCall : ((AssertableLogProvider)((Object)this.actual)).getLogCalls()) {
            if (LogAssert.matchedMessage(message, logCall)) continue;
            this.failWithMessage("Expected each log message to contain '%s', but message '%s' doesn't", new Object[]{message, logCall.toLogLikeString()});
        }
        return this;
    }

    public AbstractThrowableAssert<?, ? extends Throwable> assertExceptionForLogMessage(String message) {
        this.isNotNull();
        this.haveMessage(message);
        Optional<AssertableLogProvider.LogCall> logCall = ((AssertableLogProvider)((Object)this.actual)).getLogCalls().stream().filter(call -> this.matchedLogger((AssertableLogProvider.LogCall)call) && this.matchedLevel((AssertableLogProvider.LogCall)call) && LogAssert.matchedMessage(message, call)).findFirst();
        if (logCall.isEmpty()) {
            this.failWithMessage("Expected log call with message `%s` not found in:%n%s.", new Object[]{message, ((AssertableLogProvider)((Object)this.actual)).serialize()});
        }
        return Assertions.assertThat((Throwable)logCall.get().getThrowable());
    }

    public LogAssert containsMessageWithException(String message, Throwable t) {
        this.isNotNull();
        Objects.requireNonNull(t);
        if (!this.haveMessageWithException(message, t)) {
            this.failWithMessage("Expected log to contain message `%s` with exception: `%s`. But no matches found in:%n%s", new Object[]{message, Exceptions.stringify((Throwable)t), ((AssertableLogProvider)((Object)this.actual)).serialize()});
        }
        return this;
    }

    public LogAssert containsMessageWithExceptionMatching(String message, Predicate<Throwable> predicate) {
        this.isNotNull();
        Objects.requireNonNull(predicate);
        if (!this.haveMessageWithExceptionMatching(message, predicate)) {
            this.failWithMessage("Expected log to contain message `%s` with exception matching predicate. But no matches found in:%n%s", new Object[]{message, ((AssertableLogProvider)((Object)this.actual)).serialize()});
        }
        return this;
    }

    public LogAssert containsMessageWithExceptionWithCause(String message, Throwable t) {
        this.isNotNull();
        Objects.requireNonNull(t);
        if (!this.haveMessageWithExceptionWithCause(message, t)) {
            this.failWithMessage("Expected log to contain message `%s` with exception with cause `%s`. But no matches found in:%n%s", new Object[]{message, Exceptions.stringify((Throwable)t), ((AssertableLogProvider)((Object)this.actual)).serialize()});
        }
        return this;
    }

    public LogAssert containsException(Throwable t) {
        Objects.requireNonNull(t);
        this.isNotNull();
        if (((AssertableLogProvider)((Object)this.actual)).getLogCalls().stream().noneMatch(call -> this.matchedLogger((AssertableLogProvider.LogCall)call) && this.matchedLevel((AssertableLogProvider.LogCall)call) && t.equals(call.getThrowable()))) {
            this.failWithMessage("Expected log to contain exception: `%s`. But no matches found in:%n%s", new Object[]{Exceptions.stringify((Throwable)t), ((AssertableLogProvider)((Object)this.actual)).serialize()});
        }
        return this;
    }

    private boolean haveMessageWithException(String message, Throwable t) {
        return ((AssertableLogProvider)((Object)this.actual)).getLogCalls().stream().anyMatch(call -> this.matchedLogger((AssertableLogProvider.LogCall)call) && this.matchedLevel((AssertableLogProvider.LogCall)call) && t.equals(call.getThrowable()) && LogAssert.matchedMessage(message, call));
    }

    private boolean haveMessageWithExceptionMatching(String message, Predicate<Throwable> predicate) {
        return ((AssertableLogProvider)((Object)this.actual)).getLogCalls().stream().anyMatch(call -> this.matchedLogger((AssertableLogProvider.LogCall)call) && this.matchedLevel((AssertableLogProvider.LogCall)call) && predicate.test(call.getThrowable()) && LogAssert.matchedMessage(message, call));
    }

    private boolean haveMessageWithExceptionWithCause(String message, Throwable cause) {
        return ((AssertableLogProvider)((Object)this.actual)).getLogCalls().stream().anyMatch(call -> this.matchedLogger((AssertableLogProvider.LogCall)call) && this.matchedLevel((AssertableLogProvider.LogCall)call) && cause.equals(Throwables.getRootCause((Throwable)call.getThrowable())) && LogAssert.matchedMessage(message, call));
    }

    private boolean haveMessageWithArguments(String message, Object ... arguments) {
        Queue<AssertableLogProvider.LogCall> logCalls = ((AssertableLogProvider)((Object)this.actual)).getLogCalls();
        return logCalls.stream().anyMatch(call -> this.matchedLogger((AssertableLogProvider.LogCall)call) && this.matchedLevel((AssertableLogProvider.LogCall)call) && LogAssert.matchedArguments(call, arguments) && LogAssert.matchedMessage(message, call));
    }

    private boolean haveMessageWithArgumentsContaining(String message, Object ... arguments) {
        Queue<AssertableLogProvider.LogCall> logCalls = ((AssertableLogProvider)((Object)this.actual)).getLogCalls();
        return logCalls.stream().anyMatch(call -> this.matchedLogger((AssertableLogProvider.LogCall)call) && this.matchedLevel((AssertableLogProvider.LogCall)call) && LogAssert.matchedArgumentsContains(call, arguments) && LogAssert.matchedMessage(message, call));
    }

    private boolean haveMessageWithArgumentsMatching(String message, Predicate<Object[]> argumentMatcher) {
        Queue<AssertableLogProvider.LogCall> logCalls = ((AssertableLogProvider)((Object)this.actual)).getLogCalls();
        return logCalls.stream().anyMatch(call -> this.matchedLogger((AssertableLogProvider.LogCall)call) && this.matchedLevel((AssertableLogProvider.LogCall)call) && LogAssert.matchedMessage(message, call) && argumentMatcher.test(call.getArguments()));
    }

    private boolean haveMessage(String message) {
        return this.haveMessage((String logMessage) -> logMessage.contains(message));
    }

    private boolean haveMessage(Predicate<String> message) {
        Queue<AssertableLogProvider.LogCall> logCalls = ((AssertableLogProvider)((Object)this.actual)).getLogCalls();
        return logCalls.stream().anyMatch(call -> this.matchedLogger((AssertableLogProvider.LogCall)call) && this.matchedLevel((AssertableLogProvider.LogCall)call) && LogAssert.matchedMessage(message, call));
    }

    private int messageIndex(String message, int startIndex) {
        Queue<AssertableLogProvider.LogCall> logCalls = ((AssertableLogProvider)((Object)this.actual)).getLogCalls();
        int index = 0;
        for (AssertableLogProvider.LogCall call : logCalls) {
            if (index >= startIndex && this.matchedLogger(call) && this.matchedLevel(call) && LogAssert.matchedMessage(message, call)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private long messageMatchCount(String message) {
        Queue<AssertableLogProvider.LogCall> logCalls = ((AssertableLogProvider)((Object)this.actual)).getLogCalls();
        return logCalls.stream().filter(call -> this.matchedLogger((AssertableLogProvider.LogCall)call) && this.matchedLevel((AssertableLogProvider.LogCall)call) && LogAssert.matchedMessage(message, call)).count();
    }

    private static boolean matchedArgumentsContains(AssertableLogProvider.LogCall call, Object[] arguments) {
        Object[] callArguments = call.getArguments();
        for (int i = 0; i < arguments.length; ++i) {
            if (Objects.toString(callArguments[i]).contains(Objects.toString(arguments[i]))) continue;
            return false;
        }
        return true;
    }

    private static boolean matchedArguments(AssertableLogProvider.LogCall call, Object[] arguments) {
        return Arrays.equals(call.getArguments(), arguments);
    }

    private static boolean matchedMessage(String message, AssertableLogProvider.LogCall call) {
        return LogAssert.matchedMessage((String logMessage) -> logMessage.contains(message), call);
    }

    private static boolean matchedMessage(Predicate<String> predicate, AssertableLogProvider.LogCall call) {
        return predicate.test(call.getMessage()) || predicate.test(call.toLogLikeString());
    }

    private boolean matchedLogger(AssertableLogProvider.LogCall call) {
        return this.loggerClazz == null || this.loggerClazz.getName().equals(call.getContext()) || this.loggerClazz.getSimpleName().equals(call.getContext());
    }

    private boolean matchedLevel(AssertableLogProvider.LogCall call) {
        return this.logLevel == null || this.logLevel == call.getLevel();
    }
}

