/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.analysis;

import java.io.Reader;
import java.util.Map;
import java.util.Set;
import org.neo4j.shaded.lucene9.analysis.AbstractAnalysisFactory;
import org.neo4j.shaded.lucene9.analysis.AnalysisSPILoader;

public abstract class CharFilterFactory
extends AbstractAnalysisFactory {
    public static CharFilterFactory forName(String name, Map<String, String> args) {
        return Holder.getLoader().newInstance(name, args);
    }

    public static Class<? extends CharFilterFactory> lookupClass(String name) {
        return Holder.getLoader().lookupClass(name);
    }

    public static Set<String> availableCharFilters() {
        return Holder.getLoader().availableServices();
    }

    public static String findSPIName(Class<? extends CharFilterFactory> serviceClass) {
        try {
            return AnalysisSPILoader.lookupSPIName(serviceClass);
        }
        catch (IllegalAccessException | IllegalStateException | NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void reloadCharFilters(ClassLoader classloader) {
        Holder.getLoader().reload(classloader);
    }

    protected CharFilterFactory() {
    }

    protected CharFilterFactory(Map<String, String> args) {
        super(args);
    }

    public abstract Reader create(Reader var1);

    public Reader normalize(Reader input) {
        return input;
    }

    private static final class Holder {
        private static final AnalysisSPILoader<CharFilterFactory> LOADER = new AnalysisSPILoader<CharFilterFactory>(CharFilterFactory.class);

        private Holder() {
        }

        static AnalysisSPILoader<CharFilterFactory> getLoader() {
            if (LOADER == null) {
                throw new IllegalStateException("You tried to lookup a CharFilterFactory by name before all factories could be initialized. This likely happens if you call CharFilterFactory#forName from a CharFilterFactory's ctor.");
            }
            return LOADER;
        }
    }
}

