/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.analysis.boost;

import java.io.IOException;
import org.neo4j.shaded.lucene9.analysis.TokenFilter;
import org.neo4j.shaded.lucene9.analysis.TokenStream;
import org.neo4j.shaded.lucene9.analysis.tokenattributes.CharTermAttribute;
import org.neo4j.shaded.lucene9.search.BoostAttribute;
import org.neo4j.shaded.lucene9.util.IgnoreRandomChains;

@IgnoreRandomChains(reason="requires a special encoded token value, so it may fail with random data")
public final class DelimitedBoostTokenFilter
extends TokenFilter {
    private final char delimiter;
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final BoostAttribute boostAtt = this.addAttribute(BoostAttribute.class);

    public DelimitedBoostTokenFilter(TokenStream input, char delimiter) {
        super(input);
        this.delimiter = delimiter;
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            char[] buffer = this.termAtt.buffer();
            int length = this.termAtt.length();
            for (int i = 0; i < length; ++i) {
                if (buffer[i] != this.delimiter) continue;
                float boost = Float.parseFloat(new String(buffer, i + 1, length - (i + 1)));
                this.boostAtt.setBoost(boost);
                this.termAtt.setLength(i);
                return true;
            }
            return true;
        }
        return false;
    }
}

