/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.analysis.core;

import java.util.Map;
import org.neo4j.shaded.lucene9.analysis.TokenizerFactory;
import org.neo4j.shaded.lucene9.analysis.core.KeywordTokenizer;
import org.neo4j.shaded.lucene9.util.AttributeFactory;

public class KeywordTokenizerFactory
extends TokenizerFactory {
    public static final String NAME = "keyword";
    private final int maxTokenLen;

    public KeywordTokenizerFactory(Map<String, String> args) {
        super(args);
        this.maxTokenLen = this.getInt(args, "maxTokenLen", 256);
        if (this.maxTokenLen > 0x100000 || this.maxTokenLen <= 0) {
            throw new IllegalArgumentException("maxTokenLen must be greater than 0 and less than 1048576 passed: " + this.maxTokenLen);
        }
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    public KeywordTokenizerFactory() {
        throw KeywordTokenizerFactory.defaultCtorException();
    }

    @Override
    public KeywordTokenizer create(AttributeFactory factory) {
        return new KeywordTokenizer(factory, this.maxTokenLen);
    }
}

