/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.analysis.core;

import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import org.neo4j.shaded.lucene9.analysis.Analyzer;
import org.neo4j.shaded.lucene9.analysis.CharArraySet;
import org.neo4j.shaded.lucene9.analysis.LowerCaseFilter;
import org.neo4j.shaded.lucene9.analysis.StopFilter;
import org.neo4j.shaded.lucene9.analysis.StopwordAnalyzerBase;
import org.neo4j.shaded.lucene9.analysis.TokenStream;
import org.neo4j.shaded.lucene9.analysis.core.LetterTokenizer;

public final class StopAnalyzer
extends StopwordAnalyzerBase {
    public StopAnalyzer(CharArraySet stopWords) {
        super(stopWords);
    }

    public StopAnalyzer(Path stopwordsFile) throws IOException {
        this(StopAnalyzer.loadStopwordSet(stopwordsFile));
    }

    public StopAnalyzer(Reader stopwords) throws IOException {
        this(StopAnalyzer.loadStopwordSet(stopwords));
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        LetterTokenizer source = new LetterTokenizer();
        return new Analyzer.TokenStreamComponents(source, (TokenStream)new StopFilter(new LowerCaseFilter(source), this.stopwords));
    }

    @Override
    protected TokenStream normalize(String fieldName, TokenStream in) {
        return new LowerCaseFilter(in);
    }
}

