/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.analysis.core;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.neo4j.shaded.lucene9.analysis.TokenFilterFactory;
import org.neo4j.shaded.lucene9.analysis.TokenStream;
import org.neo4j.shaded.lucene9.analysis.core.TypeTokenFilter;
import org.neo4j.shaded.lucene9.util.ResourceLoader;
import org.neo4j.shaded.lucene9.util.ResourceLoaderAware;

public class TypeTokenFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    public static final String NAME = "type";
    private final boolean useWhitelist;
    private final String stopTypesFiles;
    private Set<String> stopTypes;

    public TypeTokenFilterFactory(Map<String, String> args) {
        super(args);
        this.stopTypesFiles = this.require(args, "types");
        this.useWhitelist = this.getBoolean(args, "useWhitelist", false);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    public TypeTokenFilterFactory() {
        throw TypeTokenFilterFactory.defaultCtorException();
    }

    @Override
    public void inform(ResourceLoader loader) throws IOException {
        List<String> files = this.splitFileNames(this.stopTypesFiles);
        if (files.size() > 0) {
            this.stopTypes = new HashSet<String>();
            for (String file : files) {
                List<String> typesLines = this.getLines(loader, file.trim());
                this.stopTypes.addAll(typesLines);
            }
        }
    }

    public Set<String> getStopTypes() {
        return this.stopTypes;
    }

    @Override
    public TokenStream create(TokenStream input) {
        TypeTokenFilter filter = new TypeTokenFilter(input, this.stopTypes, this.useWhitelist);
        return filter;
    }
}

