/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.analysis.email;

import java.io.IOException;
import org.neo4j.shaded.lucene9.analysis.Tokenizer;
import org.neo4j.shaded.lucene9.analysis.email.UAX29URLEmailTokenizerImpl;
import org.neo4j.shaded.lucene9.analysis.standard.StandardTokenizer;
import org.neo4j.shaded.lucene9.analysis.tokenattributes.CharTermAttribute;
import org.neo4j.shaded.lucene9.analysis.tokenattributes.OffsetAttribute;
import org.neo4j.shaded.lucene9.analysis.tokenattributes.PositionIncrementAttribute;
import org.neo4j.shaded.lucene9.analysis.tokenattributes.TypeAttribute;
import org.neo4j.shaded.lucene9.util.AttributeFactory;

public final class UAX29URLEmailTokenizer
extends Tokenizer {
    private final UAX29URLEmailTokenizerImpl scanner;
    public static final int ALPHANUM = 0;
    public static final int NUM = 1;
    public static final int SOUTHEAST_ASIAN = 2;
    public static final int IDEOGRAPHIC = 3;
    public static final int HIRAGANA = 4;
    public static final int KATAKANA = 5;
    public static final int HANGUL = 6;
    public static final int URL = 7;
    public static final int EMAIL = 8;
    public static final int EMOJI = 9;
    public static final String[] TOKEN_TYPES = new String[]{StandardTokenizer.TOKEN_TYPES[0], StandardTokenizer.TOKEN_TYPES[1], StandardTokenizer.TOKEN_TYPES[2], StandardTokenizer.TOKEN_TYPES[3], StandardTokenizer.TOKEN_TYPES[4], StandardTokenizer.TOKEN_TYPES[5], StandardTokenizer.TOKEN_TYPES[6], "<URL>", "<EMAIL>", StandardTokenizer.TOKEN_TYPES[7]};
    public static final int MAX_TOKEN_LENGTH_LIMIT = 0x100000;
    private int skippedPositions;
    private int maxTokenLength = 255;
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final OffsetAttribute offsetAtt = this.addAttribute(OffsetAttribute.class);
    private final PositionIncrementAttribute posIncrAtt = this.addAttribute(PositionIncrementAttribute.class);
    private final TypeAttribute typeAtt = this.addAttribute(TypeAttribute.class);

    public void setMaxTokenLength(int length) {
        if (length < 1) {
            throw new IllegalArgumentException("maxTokenLength must be greater than zero");
        }
        if (length > 0x100000) {
            throw new IllegalArgumentException("maxTokenLength may not exceed 1048576");
        }
        if (length != this.maxTokenLength) {
            this.maxTokenLength = length;
            this.scanner.setBufferSize(length);
        }
    }

    public int getMaxTokenLength() {
        return this.maxTokenLength;
    }

    public UAX29URLEmailTokenizer() {
        this.scanner = this.getScanner();
    }

    public UAX29URLEmailTokenizer(AttributeFactory factory) {
        super(factory);
        this.scanner = this.getScanner();
    }

    private UAX29URLEmailTokenizerImpl getScanner() {
        return new UAX29URLEmailTokenizerImpl(this.input);
    }

    @Override
    public final boolean incrementToken() throws IOException {
        this.clearAttributes();
        this.skippedPositions = 0;
        int tokenType;
        while ((tokenType = this.scanner.getNextToken()) != -1) {
            if (this.scanner.yylength() <= this.maxTokenLength) {
                this.posIncrAtt.setPositionIncrement(this.skippedPositions + 1);
                this.scanner.getText(this.termAtt);
                int start = this.scanner.yychar();
                this.offsetAtt.setOffset(this.correctOffset(start), this.correctOffset(start + this.termAtt.length()));
                this.typeAtt.setType(TOKEN_TYPES[tokenType]);
                return true;
            }
            ++this.skippedPositions;
        }
        return false;
    }

    @Override
    public final void end() throws IOException {
        super.end();
        int finalOffset = this.correctOffset(this.scanner.yychar() + this.scanner.yylength());
        this.offsetAtt.setOffset(finalOffset, finalOffset);
        this.posIncrAtt.setPositionIncrement(this.posIncrAtt.getPositionIncrement() + this.skippedPositions);
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.scanner.yyreset(this.input);
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.scanner.yyreset(this.input);
        this.skippedPositions = 0;
    }
}

