/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.analysis.hunspell;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public abstract class DictEntry {
    private final String stem;

    DictEntry(String stem) {
        this.stem = stem;
    }

    public String toString() {
        String morph;
        Object result = this.stem;
        String flags = this.getFlags();
        if (!flags.isEmpty()) {
            result = (String)result + "/" + flags;
        }
        if (!(morph = this.getMorphologicalData()).isEmpty()) {
            result = (String)result + " " + morph;
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DictEntry)) {
            return false;
        }
        DictEntry that = (DictEntry)o;
        return this.stem.equals(that.stem) && this.getMorphologicalData().equals(that.getMorphologicalData()) && this.getFlags().equals(that.getFlags());
    }

    public int hashCode() {
        return Objects.hash(this.stem, this.getFlags(), this.getMorphologicalData());
    }

    public String getStem() {
        return this.stem;
    }

    public abstract String getFlags();

    public abstract String getMorphologicalData();

    public List<String> getMorphologicalValues(String key) {
        assert (key.length() == 3 && key.charAt(2) == ':') : "A morphological data key should consist of two letters followed by a semicolon, found: " + key;
        String data = this.getMorphologicalData();
        if (data.isEmpty() || !data.contains(key)) {
            return Collections.emptyList();
        }
        return Arrays.stream(data.split(" ")).filter(s -> s.startsWith(key)).map(s -> s.substring(3)).collect(Collectors.toList());
    }

    static DictEntry create(String stem, final String flags) {
        return new DictEntry(stem){

            @Override
            public String getFlags() {
                return flags;
            }

            @Override
            public String getMorphologicalData() {
                return "";
            }
        };
    }
}

