/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.analysis.id;

import java.io.IOException;
import org.neo4j.shaded.lucene9.analysis.TokenFilter;
import org.neo4j.shaded.lucene9.analysis.TokenStream;
import org.neo4j.shaded.lucene9.analysis.id.IndonesianStemmer;
import org.neo4j.shaded.lucene9.analysis.tokenattributes.CharTermAttribute;
import org.neo4j.shaded.lucene9.analysis.tokenattributes.KeywordAttribute;

public final class IndonesianStemFilter
extends TokenFilter {
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final KeywordAttribute keywordAtt = this.addAttribute(KeywordAttribute.class);
    private final IndonesianStemmer stemmer = new IndonesianStemmer();
    private final boolean stemDerivational;

    public IndonesianStemFilter(TokenStream input) {
        this(input, true);
    }

    public IndonesianStemFilter(TokenStream input, boolean stemDerivational) {
        super(input);
        this.stemDerivational = stemDerivational;
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            if (!this.keywordAtt.isKeyword()) {
                int newlen = this.stemmer.stem(this.termAtt.buffer(), this.termAtt.length(), this.stemDerivational);
                this.termAtt.setLength(newlen);
            }
            return true;
        }
        return false;
    }
}

