/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.analysis.miscellaneous;

import java.io.IOException;
import java.util.Set;
import org.neo4j.shaded.lucene9.analysis.TokenFilter;
import org.neo4j.shaded.lucene9.analysis.TokenStream;
import org.neo4j.shaded.lucene9.analysis.tokenattributes.CharTermAttribute;
import org.neo4j.shaded.lucene9.analysis.tokenattributes.FlagsAttribute;
import org.neo4j.shaded.lucene9.analysis.tokenattributes.PositionIncrementAttribute;
import org.neo4j.shaded.lucene9.analysis.tokenattributes.TypeAttribute;
import org.neo4j.shaded.lucene9.util.AttributeSource;

public final class TypeAsSynonymFilter
extends TokenFilter {
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final TypeAttribute typeAtt = this.addAttribute(TypeAttribute.class);
    private final PositionIncrementAttribute posIncrAtt = this.addAttribute(PositionIncrementAttribute.class);
    private final FlagsAttribute flagsAtt = this.addAttribute(FlagsAttribute.class);
    private final String prefix;
    private final Set<String> ignore;
    private final int synFlagsMask;
    private AttributeSource.State savedToken = null;

    public TypeAsSynonymFilter(TokenStream input) {
        this(input, null, null, -1);
    }

    public TypeAsSynonymFilter(TokenStream input, String prefix) {
        this(input, prefix, null, -1);
    }

    public TypeAsSynonymFilter(TokenStream input, String prefix, Set<String> ignore, int synFlagsMask) {
        super(input);
        this.prefix = prefix;
        this.ignore = ignore;
        this.synFlagsMask = synFlagsMask;
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (this.savedToken != null) {
            this.restoreState(this.savedToken);
            this.savedToken = null;
            this.termAtt.setEmpty();
            if (this.prefix != null) {
                this.termAtt.append(this.prefix);
            }
            this.termAtt.append(this.typeAtt.type());
            this.posIncrAtt.setPositionIncrement(0);
            this.flagsAtt.setFlags(this.flagsAtt.getFlags() & this.synFlagsMask);
            return true;
        }
        if (this.input.incrementToken()) {
            String type = this.typeAtt.type();
            if (this.ignore == null || !this.ignore.contains(type)) {
                this.savedToken = this.captureState();
            }
            return true;
        }
        return false;
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.savedToken = null;
    }
}

