/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.analysis.ngram;

import java.util.Map;
import org.neo4j.shaded.lucene9.analysis.TokenFilter;
import org.neo4j.shaded.lucene9.analysis.TokenFilterFactory;
import org.neo4j.shaded.lucene9.analysis.TokenStream;
import org.neo4j.shaded.lucene9.analysis.ngram.EdgeNGramTokenFilter;

public class EdgeNGramFilterFactory
extends TokenFilterFactory {
    public static final String NAME = "edgeNGram";
    private final int maxGramSize;
    private final int minGramSize;
    private final boolean preserveOriginal;

    public EdgeNGramFilterFactory(Map<String, String> args) {
        super(args);
        this.minGramSize = this.requireInt(args, "minGramSize");
        this.maxGramSize = this.requireInt(args, "maxGramSize");
        this.preserveOriginal = this.getBoolean(args, "preserveOriginal", false);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    public EdgeNGramFilterFactory() {
        throw EdgeNGramFilterFactory.defaultCtorException();
    }

    @Override
    public TokenFilter create(TokenStream input) {
        return new EdgeNGramTokenFilter(input, this.minGramSize, this.maxGramSize, this.preserveOriginal);
    }
}

