/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.analysis.ngram;

import java.util.Map;
import org.neo4j.shaded.lucene9.analysis.Tokenizer;
import org.neo4j.shaded.lucene9.analysis.TokenizerFactory;
import org.neo4j.shaded.lucene9.analysis.ngram.NGramTokenizer;
import org.neo4j.shaded.lucene9.util.AttributeFactory;

public class NGramTokenizerFactory
extends TokenizerFactory {
    public static final String NAME = "nGram";
    private final int maxGramSize;
    private final int minGramSize;

    public NGramTokenizerFactory(Map<String, String> args) {
        super(args);
        this.minGramSize = this.getInt(args, "minGramSize", 1);
        this.maxGramSize = this.getInt(args, "maxGramSize", 2);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    public NGramTokenizerFactory() {
        throw NGramTokenizerFactory.defaultCtorException();
    }

    @Override
    public Tokenizer create(AttributeFactory factory) {
        return new NGramTokenizer(factory, this.minGramSize, this.maxGramSize);
    }
}

