/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.analysis.pattern;

import java.util.Arrays;
import java.util.Map;
import java.util.regex.Pattern;
import org.neo4j.shaded.lucene9.analysis.TokenFilterFactory;
import org.neo4j.shaded.lucene9.analysis.TokenStream;
import org.neo4j.shaded.lucene9.analysis.pattern.PatternReplaceFilter;

public class PatternReplaceFilterFactory
extends TokenFilterFactory {
    public static final String NAME = "patternReplace";
    final Pattern pattern;
    final String replacement;
    final boolean replaceAll;

    public PatternReplaceFilterFactory(Map<String, String> args) {
        super(args);
        this.pattern = this.getPattern(args, "pattern");
        this.replacement = this.get(args, "replacement");
        this.replaceAll = "all".equals(this.get(args, "replace", Arrays.asList("all", "first"), "all"));
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    public PatternReplaceFilterFactory() {
        throw PatternReplaceFilterFactory.defaultCtorException();
    }

    @Override
    public PatternReplaceFilter create(TokenStream input) {
        return new PatternReplaceFilter(input, this.pattern, this.replacement, this.replaceAll);
    }
}

