/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.analysis.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.neo4j.shaded.lucene9.analysis.Analyzer;
import org.neo4j.shaded.lucene9.analysis.AnalyzerWrapper;
import org.neo4j.shaded.lucene9.analysis.CharArraySet;
import org.neo4j.shaded.lucene9.analysis.StopFilter;
import org.neo4j.shaded.lucene9.analysis.TokenStream;
import org.neo4j.shaded.lucene9.index.FieldInfos;
import org.neo4j.shaded.lucene9.index.IndexReader;
import org.neo4j.shaded.lucene9.index.MultiTerms;
import org.neo4j.shaded.lucene9.index.Term;
import org.neo4j.shaded.lucene9.index.Terms;
import org.neo4j.shaded.lucene9.index.TermsEnum;
import org.neo4j.shaded.lucene9.util.BytesRef;
import org.neo4j.shaded.lucene9.util.CharsRefBuilder;

public final class QueryAutoStopWordAnalyzer
extends AnalyzerWrapper {
    private final Analyzer delegate;
    private final Map<String, Set<String>> stopWordsPerField = new HashMap<String, Set<String>>();
    public static final float defaultMaxDocFreqPercent = 0.4f;

    public QueryAutoStopWordAnalyzer(Analyzer delegate, IndexReader indexReader) throws IOException {
        this(delegate, indexReader, 0.4f);
    }

    public QueryAutoStopWordAnalyzer(Analyzer delegate, IndexReader indexReader, int maxDocFreq) throws IOException {
        this(delegate, indexReader, FieldInfos.getIndexedFields(indexReader), maxDocFreq);
    }

    public QueryAutoStopWordAnalyzer(Analyzer delegate, IndexReader indexReader, float maxPercentDocs) throws IOException {
        this(delegate, indexReader, FieldInfos.getIndexedFields(indexReader), maxPercentDocs);
    }

    public QueryAutoStopWordAnalyzer(Analyzer delegate, IndexReader indexReader, Collection<String> fields, float maxPercentDocs) throws IOException {
        this(delegate, indexReader, fields, (int)((float)indexReader.numDocs() * maxPercentDocs));
    }

    public QueryAutoStopWordAnalyzer(Analyzer delegate, IndexReader indexReader, Collection<String> fields, int maxDocFreq) throws IOException {
        super(delegate.getReuseStrategy());
        this.delegate = delegate;
        for (String field : fields) {
            HashSet<String> stopWords = new HashSet<String>();
            Terms terms = MultiTerms.getTerms(indexReader, field);
            CharsRefBuilder spare = new CharsRefBuilder();
            if (terms != null) {
                BytesRef text;
                TermsEnum te = terms.iterator();
                while ((text = te.next()) != null) {
                    if (te.docFreq() <= maxDocFreq) continue;
                    spare.copyUTF8Bytes(text);
                    stopWords.add(spare.toString());
                }
            }
            this.stopWordsPerField.put(field, stopWords);
        }
    }

    @Override
    protected Analyzer getWrappedAnalyzer(String fieldName) {
        return this.delegate;
    }

    @Override
    protected Analyzer.TokenStreamComponents wrapComponents(String fieldName, Analyzer.TokenStreamComponents components) {
        Set<String> stopWords = this.stopWordsPerField.get(fieldName);
        if (stopWords == null) {
            return components;
        }
        StopFilter stopFilter = new StopFilter(components.getTokenStream(), new CharArraySet(stopWords, false));
        return new Analyzer.TokenStreamComponents(components.getSource(), (TokenStream)stopFilter);
    }

    public String[] getStopWords(String fieldName) {
        Set<String> stopWords = this.stopWordsPerField.get(fieldName);
        return stopWords != null ? stopWords.toArray(new String[stopWords.size()]) : new String[]{};
    }

    public Term[] getStopWords() {
        ArrayList<Term> allStopWords = new ArrayList<Term>();
        for (Map.Entry<String, Set<String>> entry : this.stopWordsPerField.entrySet()) {
            String field = entry.getKey();
            Set<String> stopWords = entry.getValue();
            for (String text : stopWords) {
                allStopWords.add(new Term(field, text));
            }
        }
        return allStopWords.toArray(new Term[allStopWords.size()]);
    }
}

