/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.analysis.sr;

import java.util.Arrays;
import java.util.Map;
import org.neo4j.shaded.lucene9.analysis.TokenFilterFactory;
import org.neo4j.shaded.lucene9.analysis.TokenStream;
import org.neo4j.shaded.lucene9.analysis.sr.SerbianNormalizationFilter;
import org.neo4j.shaded.lucene9.analysis.sr.SerbianNormalizationRegularFilter;

public class SerbianNormalizationFilterFactory
extends TokenFilterFactory {
    public static final String NAME = "serbianNormalization";
    final String haircut;

    public SerbianNormalizationFilterFactory(Map<String, String> args) {
        super(args);
        this.haircut = this.get(args, "haircut", Arrays.asList("bald", "regular"), "bald");
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    public SerbianNormalizationFilterFactory() {
        throw SerbianNormalizationFilterFactory.defaultCtorException();
    }

    @Override
    public TokenStream create(TokenStream input) {
        if (this.haircut.equals("regular")) {
            return new SerbianNormalizationRegularFilter(input);
        }
        return new SerbianNormalizationFilter(input);
    }

    @Override
    public TokenStream normalize(TokenStream input) {
        return this.create(input);
    }
}

