/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.analysis.synonym;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.text.ParseException;
import org.neo4j.shaded.lucene9.analysis.Analyzer;
import org.neo4j.shaded.lucene9.analysis.synonym.SynonymMap;
import org.neo4j.shaded.lucene9.util.ArrayUtil;
import org.neo4j.shaded.lucene9.util.CharsRef;
import org.neo4j.shaded.lucene9.util.CharsRefBuilder;

public class WordnetSynonymParser
extends SynonymMap.Parser {
    private final boolean expand;

    public WordnetSynonymParser(boolean dedup, boolean expand, Analyzer analyzer) {
        super(dedup, analyzer);
        this.expand = expand;
    }

    @Override
    public void parse(Reader in) throws IOException, ParseException {
        try (LineNumberReader br = new LineNumberReader(in);){
            String line = null;
            String lastSynSetID = "";
            CharsRef[] synset = new CharsRef[8];
            int synsetSize = 0;
            while ((line = br.readLine()) != null) {
                String synSetID = line.substring(2, 11);
                if (!synSetID.equals(lastSynSetID)) {
                    this.addInternal(synset, synsetSize);
                    synsetSize = 0;
                }
                synset = ArrayUtil.grow(synset, synsetSize + 1);
                synset[synsetSize] = this.parseSynonym(line, new CharsRefBuilder());
                ++synsetSize;
                lastSynSetID = synSetID;
            }
            this.addInternal(synset, synsetSize);
        }
    }

    private CharsRef parseSynonym(String line, CharsRefBuilder reuse) throws IOException {
        if (reuse == null) {
            reuse = new CharsRefBuilder();
        }
        int start = line.indexOf(39) + 1;
        int end = line.lastIndexOf(39);
        String text = line.substring(start, end).replace("''", "'");
        return this.analyze(text, reuse);
    }

    private void addInternal(CharsRef[] synset, int size) {
        if (size <= 1) {
            return;
        }
        if (this.expand) {
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < size; ++j) {
                    if (i == j) continue;
                    this.add(synset[i], synset[j], true);
                }
            }
        } else {
            for (int i = 0; i < size; ++i) {
                this.add(synset[i], synset[0], false);
            }
        }
    }
}

