/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.analysis.wikipedia;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.neo4j.shaded.lucene9.analysis.TokenizerFactory;
import org.neo4j.shaded.lucene9.analysis.wikipedia.WikipediaTokenizer;
import org.neo4j.shaded.lucene9.util.AttributeFactory;

public class WikipediaTokenizerFactory
extends TokenizerFactory {
    public static final String NAME = "wikipedia";
    public static final String TOKEN_OUTPUT = "tokenOutput";
    public static final String UNTOKENIZED_TYPES = "untokenizedTypes";
    protected final int tokenOutput;
    protected Set<String> untokenizedTypes;

    public WikipediaTokenizerFactory(Map<String, String> args) {
        super(args);
        this.tokenOutput = this.getInt(args, TOKEN_OUTPUT, 0);
        this.untokenizedTypes = this.getSet(args, UNTOKENIZED_TYPES);
        if (this.untokenizedTypes == null) {
            this.untokenizedTypes = Collections.emptySet();
        }
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    public WikipediaTokenizerFactory() {
        throw WikipediaTokenizerFactory.defaultCtorException();
    }

    @Override
    public WikipediaTokenizer create(AttributeFactory factory) {
        return new WikipediaTokenizer(factory, this.tokenOutput, this.untokenizedTypes);
    }
}

