/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.backward_codecs.lucene86;

import java.util.Objects;
import org.neo4j.shaded.lucene9.backward_codecs.lucene50.Lucene50CompoundFormat;
import org.neo4j.shaded.lucene9.backward_codecs.lucene50.Lucene50LiveDocsFormat;
import org.neo4j.shaded.lucene9.backward_codecs.lucene50.Lucene50StoredFieldsFormat;
import org.neo4j.shaded.lucene9.backward_codecs.lucene50.Lucene50TermVectorsFormat;
import org.neo4j.shaded.lucene9.backward_codecs.lucene60.Lucene60FieldInfosFormat;
import org.neo4j.shaded.lucene9.backward_codecs.lucene80.Lucene80NormsFormat;
import org.neo4j.shaded.lucene9.backward_codecs.lucene84.Lucene84PostingsFormat;
import org.neo4j.shaded.lucene9.backward_codecs.lucene86.Lucene86PointsFormat;
import org.neo4j.shaded.lucene9.backward_codecs.lucene86.Lucene86SegmentInfoFormat;
import org.neo4j.shaded.lucene9.codecs.Codec;
import org.neo4j.shaded.lucene9.codecs.CompoundFormat;
import org.neo4j.shaded.lucene9.codecs.DocValuesFormat;
import org.neo4j.shaded.lucene9.codecs.FieldInfosFormat;
import org.neo4j.shaded.lucene9.codecs.KnnVectorsFormat;
import org.neo4j.shaded.lucene9.codecs.LiveDocsFormat;
import org.neo4j.shaded.lucene9.codecs.NormsFormat;
import org.neo4j.shaded.lucene9.codecs.PointsFormat;
import org.neo4j.shaded.lucene9.codecs.PostingsFormat;
import org.neo4j.shaded.lucene9.codecs.SegmentInfoFormat;
import org.neo4j.shaded.lucene9.codecs.StoredFieldsFormat;
import org.neo4j.shaded.lucene9.codecs.TermVectorsFormat;
import org.neo4j.shaded.lucene9.codecs.perfield.PerFieldDocValuesFormat;
import org.neo4j.shaded.lucene9.codecs.perfield.PerFieldPostingsFormat;

public class Lucene86Codec
extends Codec {
    private final TermVectorsFormat vectorsFormat = new Lucene50TermVectorsFormat();
    private final FieldInfosFormat fieldInfosFormat = new Lucene60FieldInfosFormat();
    private final SegmentInfoFormat segmentInfosFormat = new Lucene86SegmentInfoFormat();
    private final LiveDocsFormat liveDocsFormat = new Lucene50LiveDocsFormat();
    private final CompoundFormat compoundFormat = new Lucene50CompoundFormat();
    private final PointsFormat pointsFormat = new Lucene86PointsFormat();
    private final PostingsFormat defaultFormat;
    private final PostingsFormat postingsFormat = new PerFieldPostingsFormat(){

        @Override
        public PostingsFormat getPostingsFormatForField(String field) {
            return Lucene86Codec.this.getPostingsFormatForField(field);
        }
    };
    private final DocValuesFormat docValuesFormat = new PerFieldDocValuesFormat(){

        @Override
        public DocValuesFormat getDocValuesFormatForField(String field) {
            return Lucene86Codec.this.getDocValuesFormatForField(field);
        }
    };
    private final StoredFieldsFormat storedFieldsFormat;
    private final DocValuesFormat defaultDVFormat = DocValuesFormat.forName("Lucene80");
    private final NormsFormat normsFormat = new Lucene80NormsFormat();

    public Lucene86Codec() {
        this(Lucene50StoredFieldsFormat.Mode.BEST_SPEED);
    }

    public Lucene86Codec(Lucene50StoredFieldsFormat.Mode mode) {
        super("Lucene86");
        this.storedFieldsFormat = new Lucene50StoredFieldsFormat(Objects.requireNonNull(mode));
        this.defaultFormat = new Lucene84PostingsFormat();
    }

    @Override
    public StoredFieldsFormat storedFieldsFormat() {
        return this.storedFieldsFormat;
    }

    @Override
    public TermVectorsFormat termVectorsFormat() {
        return this.vectorsFormat;
    }

    @Override
    public PostingsFormat postingsFormat() {
        return this.postingsFormat;
    }

    @Override
    public final FieldInfosFormat fieldInfosFormat() {
        return this.fieldInfosFormat;
    }

    @Override
    public SegmentInfoFormat segmentInfoFormat() {
        return this.segmentInfosFormat;
    }

    @Override
    public final LiveDocsFormat liveDocsFormat() {
        return this.liveDocsFormat;
    }

    @Override
    public CompoundFormat compoundFormat() {
        return this.compoundFormat;
    }

    @Override
    public PointsFormat pointsFormat() {
        return this.pointsFormat;
    }

    @Override
    public final KnnVectorsFormat knnVectorsFormat() {
        return KnnVectorsFormat.EMPTY;
    }

    public PostingsFormat getPostingsFormatForField(String field) {
        return this.defaultFormat;
    }

    public DocValuesFormat getDocValuesFormatForField(String field) {
        return this.defaultDVFormat;
    }

    @Override
    public final DocValuesFormat docValuesFormat() {
        return this.docValuesFormat;
    }

    @Override
    public NormsFormat normsFormat() {
        return this.normsFormat;
    }
}

