/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.document;

import org.neo4j.shaded.lucene9.analysis.Analyzer;
import org.neo4j.shaded.lucene9.analysis.TokenStream;
import org.neo4j.shaded.lucene9.document.Field;
import org.neo4j.shaded.lucene9.document.FieldType;
import org.neo4j.shaded.lucene9.document.ShapeDocValues;
import org.neo4j.shaded.lucene9.document.ShapeField;
import org.neo4j.shaded.lucene9.geo.Geometry;
import org.neo4j.shaded.lucene9.index.DocValuesType;
import org.neo4j.shaded.lucene9.index.IndexableFieldType;
import org.neo4j.shaded.lucene9.search.Query;

public abstract class ShapeDocValuesField
extends Field {
    protected final ShapeDocValues shapeDocValues;
    protected static final FieldType FIELD_TYPE = new FieldType();

    ShapeDocValuesField(String name, ShapeDocValues shapeDocValues) {
        super(name, FIELD_TYPE);
        this.shapeDocValues = shapeDocValues;
        this.fieldsData = shapeDocValues.binaryValue();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public IndexableFieldType fieldType() {
        return FIELD_TYPE;
    }

    @Override
    public String stringValue() {
        return null;
    }

    @Override
    public TokenStream tokenStream(Analyzer analyzer, TokenStream reuse) {
        return null;
    }

    public int numberOfTerms() {
        return this.shapeDocValues.numberOfTerms();
    }

    public static Query newGeometryQuery(String field, ShapeField.QueryRelation relation, Object ... geometries) {
        throw new IllegalStateException("geometry queries not yet supported on shape doc values for field [" + field + "]");
    }

    public abstract Geometry getCentroid();

    public abstract Geometry getBoundingBox();

    public ShapeField.DecodedTriangle.TYPE getHighestDimensionType() {
        return this.shapeDocValues.getHighestDimension();
    }

    protected abstract double decodeX(int var1);

    protected abstract double decodeY(int var1);

    static {
        FIELD_TYPE.setDocValuesType(DocValuesType.BINARY);
        FIELD_TYPE.setOmitNorms(true);
        FIELD_TYPE.freeze();
    }
}

