/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.document;

import java.io.Reader;
import org.neo4j.shaded.lucene9.analysis.TokenStream;
import org.neo4j.shaded.lucene9.document.Field;
import org.neo4j.shaded.lucene9.document.FieldType;
import org.neo4j.shaded.lucene9.document.StoredValue;
import org.neo4j.shaded.lucene9.index.IndexOptions;
import org.neo4j.shaded.lucene9.index.IndexableFieldType;

public final class TextField
extends Field {
    public static final FieldType TYPE_NOT_STORED = new FieldType();
    public static final FieldType TYPE_STORED = new FieldType();
    private final StoredValue storedValue;

    public TextField(String name, Reader reader) {
        super(name, reader, (IndexableFieldType)TYPE_NOT_STORED);
        this.storedValue = null;
    }

    public TextField(String name, String value, Field.Store store) {
        super(name, value, (IndexableFieldType)(store == Field.Store.YES ? TYPE_STORED : TYPE_NOT_STORED));
        this.storedValue = store == Field.Store.YES ? new StoredValue(value) : null;
    }

    public TextField(String name, TokenStream stream) {
        super(name, stream, (IndexableFieldType)TYPE_NOT_STORED);
        this.storedValue = null;
    }

    @Override
    public void setStringValue(String value) {
        super.setStringValue(value);
        if (this.storedValue != null) {
            this.storedValue.setStringValue(value);
        }
    }

    @Override
    public StoredValue storedValue() {
        return this.storedValue;
    }

    static {
        TYPE_NOT_STORED.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
        TYPE_NOT_STORED.setTokenized(true);
        TYPE_NOT_STORED.freeze();
        TYPE_STORED.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
        TYPE_STORED.setTokenized(true);
        TYPE_STORED.setStored(true);
        TYPE_STORED.freeze();
    }
}

