/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.index;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import org.neo4j.shaded.lucene9.index.ApproximatePriorityQueue;

final class ConcurrentApproximatePriorityQueue<T> {
    static final int MIN_CONCURRENCY = 1;
    static final int MAX_CONCURRENCY = 256;
    final int concurrency;
    final Lock[] locks;
    final ApproximatePriorityQueue<T>[] queues;

    private static final int getConcurrency() {
        int coreCount = Runtime.getRuntime().availableProcessors();
        int concurrency = coreCount / 4;
        concurrency = Math.max(1, concurrency);
        concurrency = Math.min(256, concurrency);
        return concurrency;
    }

    ConcurrentApproximatePriorityQueue() {
        this(ConcurrentApproximatePriorityQueue.getConcurrency());
    }

    ConcurrentApproximatePriorityQueue(int concurrency) {
        if (concurrency < 1 || concurrency > 256) {
            throw new IllegalArgumentException("concurrency must be in [1, 256], got " + concurrency);
        }
        this.concurrency = concurrency;
        this.locks = new Lock[concurrency];
        ApproximatePriorityQueue[] queues = new ApproximatePriorityQueue[concurrency];
        this.queues = queues;
        for (int i = 0; i < concurrency; ++i) {
            this.locks[i] = new ReentrantLock();
            queues[i] = new ApproximatePriorityQueue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(T entry, long weight) {
        int threadHash = Thread.currentThread().hashCode() & 0xFFFF;
        for (int i = 0; i < this.concurrency; ++i) {
            int index = (threadHash + i) % this.concurrency;
            Lock lock = this.locks[index];
            ApproximatePriorityQueue<T> queue = this.queues[index];
            if (!lock.tryLock()) continue;
            try {
                queue.add(entry, weight);
                return;
            }
            finally {
                lock.unlock();
            }
        }
        int index = threadHash % this.concurrency;
        Lock lock = this.locks[index];
        ApproximatePriorityQueue<T> queue = this.queues[index];
        lock.lock();
        try {
            queue.add(entry, weight);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    T poll(Predicate<T> predicate) {
        T entry;
        ApproximatePriorityQueue<T> queue;
        Lock lock;
        int index;
        int i;
        int threadHash = Thread.currentThread().hashCode() & 0xFFFF;
        for (i = 0; i < this.concurrency; ++i) {
            index = (threadHash + i) % this.concurrency;
            lock = this.locks[index];
            queue = this.queues[index];
            if (!lock.tryLock()) continue;
            try {
                entry = queue.poll(predicate);
                if (entry == null) continue;
                T t = entry;
                return t;
            }
            finally {
                lock.unlock();
            }
        }
        for (i = 0; i < this.concurrency; ++i) {
            index = (threadHash + i) % this.concurrency;
            lock = this.locks[index];
            queue = this.queues[index];
            lock.lock();
            try {
                entry = queue.poll(predicate);
                if (entry == null) continue;
                T t = entry;
                return t;
            }
            finally {
                lock.unlock();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean contains(Object o) {
        boolean assertionsAreEnabled = false;
        if (!$assertionsDisabled) {
            assertionsAreEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (!assertionsAreEnabled) {
            throw new AssertionError((Object)"contains should only be used for assertions");
        }
        for (int i = 0; i < this.concurrency; ++i) {
            Lock lock = this.locks[i];
            ApproximatePriorityQueue<T> queue = this.queues[i];
            lock.lock();
            try {
                if (!queue.contains(o)) continue;
                boolean bl = true;
                return bl;
            }
            finally {
                lock.unlock();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean remove(Object o) {
        for (int i = 0; i < this.concurrency; ++i) {
            Lock lock = this.locks[i];
            ApproximatePriorityQueue<T> queue = this.queues[i];
            lock.lock();
            try {
                if (!queue.remove(o)) continue;
                boolean bl = true;
                return bl;
            }
            finally {
                lock.unlock();
            }
        }
        return false;
    }
}

