/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.index;

import org.neo4j.shaded.lucene9.analysis.tokenattributes.OffsetAttribute;
import org.neo4j.shaded.lucene9.analysis.tokenattributes.PayloadAttribute;
import org.neo4j.shaded.lucene9.analysis.tokenattributes.PositionIncrementAttribute;
import org.neo4j.shaded.lucene9.analysis.tokenattributes.TermFrequencyAttribute;
import org.neo4j.shaded.lucene9.analysis.tokenattributes.TermToBytesRefAttribute;
import org.neo4j.shaded.lucene9.index.IndexOptions;
import org.neo4j.shaded.lucene9.util.AttributeSource;

public final class FieldInvertState {
    final int indexCreatedVersionMajor;
    final String name;
    final IndexOptions indexOptions;
    int position;
    int length;
    int numOverlap;
    int offset;
    int maxTermFrequency;
    int uniqueTermCount;
    int lastStartOffset = 0;
    int lastPosition = 0;
    AttributeSource attributeSource;
    OffsetAttribute offsetAttribute;
    PositionIncrementAttribute posIncrAttribute;
    PayloadAttribute payloadAttribute;
    TermToBytesRefAttribute termAttribute;
    TermFrequencyAttribute termFreqAttribute;

    public FieldInvertState(int indexCreatedVersionMajor, String name, IndexOptions indexOptions) {
        this.indexCreatedVersionMajor = indexCreatedVersionMajor;
        this.name = name;
        this.indexOptions = indexOptions;
    }

    public FieldInvertState(int indexCreatedVersionMajor, String name, IndexOptions indexOptions, int position, int length, int numOverlap, int offset, int maxTermFrequency, int uniqueTermCount) {
        this(indexCreatedVersionMajor, name, indexOptions);
        this.position = position;
        this.length = length;
        this.numOverlap = numOverlap;
        this.offset = offset;
        this.maxTermFrequency = maxTermFrequency;
        this.uniqueTermCount = uniqueTermCount;
    }

    void reset() {
        this.position = -1;
        this.length = 0;
        this.numOverlap = 0;
        this.offset = 0;
        this.maxTermFrequency = 0;
        this.uniqueTermCount = 0;
        this.lastStartOffset = 0;
        this.lastPosition = 0;
    }

    void setAttributeSource(AttributeSource attributeSource) {
        if (this.attributeSource != attributeSource) {
            this.attributeSource = attributeSource;
            if (attributeSource == null) {
                this.termAttribute = null;
                this.termFreqAttribute = null;
                this.posIncrAttribute = null;
                this.offsetAttribute = null;
                this.payloadAttribute = null;
            } else {
                this.termAttribute = attributeSource.getAttribute(TermToBytesRefAttribute.class);
                this.termFreqAttribute = attributeSource.addAttribute(TermFrequencyAttribute.class);
                this.posIncrAttribute = attributeSource.addAttribute(PositionIncrementAttribute.class);
                this.offsetAttribute = attributeSource.addAttribute(OffsetAttribute.class);
                this.payloadAttribute = attributeSource.getAttribute(PayloadAttribute.class);
            }
        }
    }

    public int getPosition() {
        return this.position;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getNumOverlap() {
        return this.numOverlap;
    }

    public void setNumOverlap(int numOverlap) {
        this.numOverlap = numOverlap;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getMaxTermFrequency() {
        return this.maxTermFrequency;
    }

    public int getUniqueTermCount() {
        return this.uniqueTermCount;
    }

    public AttributeSource getAttributeSource() {
        return this.attributeSource;
    }

    public String getName() {
        return this.name;
    }

    public int getIndexCreatedVersionMajor() {
        return this.indexCreatedVersionMajor;
    }

    public IndexOptions getIndexOptions() {
        return this.indexOptions;
    }
}

