/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.index;

import java.io.IOException;
import java.util.Objects;
import org.neo4j.shaded.lucene9.codecs.DocValuesProducer;
import org.neo4j.shaded.lucene9.codecs.FieldsProducer;
import org.neo4j.shaded.lucene9.codecs.KnnVectorsReader;
import org.neo4j.shaded.lucene9.codecs.NormsProducer;
import org.neo4j.shaded.lucene9.codecs.PointsReader;
import org.neo4j.shaded.lucene9.codecs.StoredFieldsReader;
import org.neo4j.shaded.lucene9.codecs.TermVectorsReader;
import org.neo4j.shaded.lucene9.index.CodecReader;
import org.neo4j.shaded.lucene9.index.FieldInfos;
import org.neo4j.shaded.lucene9.index.Fields;
import org.neo4j.shaded.lucene9.index.IndexReader;
import org.neo4j.shaded.lucene9.index.LeafMetaData;
import org.neo4j.shaded.lucene9.index.StoredFieldVisitor;
import org.neo4j.shaded.lucene9.util.Bits;

public abstract class FilterCodecReader
extends CodecReader {
    protected final CodecReader in;

    public static CodecReader unwrap(CodecReader reader) {
        while (reader instanceof FilterCodecReader) {
            reader = ((FilterCodecReader)reader).getDelegate();
        }
        return reader;
    }

    public FilterCodecReader(CodecReader in) {
        this.in = Objects.requireNonNull(in);
    }

    @Override
    public StoredFieldsReader getFieldsReader() {
        return this.in.getFieldsReader();
    }

    @Override
    public TermVectorsReader getTermVectorsReader() {
        return this.in.getTermVectorsReader();
    }

    @Override
    public NormsProducer getNormsReader() {
        return this.in.getNormsReader();
    }

    @Override
    public DocValuesProducer getDocValuesReader() {
        return this.in.getDocValuesReader();
    }

    @Override
    public FieldsProducer getPostingsReader() {
        return this.in.getPostingsReader();
    }

    @Override
    @Deprecated
    public void document(int docID, StoredFieldVisitor visitor) throws IOException {
        this.in.document(docID, visitor);
    }

    @Override
    @Deprecated
    public Fields getTermVectors(int docID) throws IOException {
        return this.in.getTermVectors(docID);
    }

    @Override
    public Bits getLiveDocs() {
        return this.in.getLiveDocs();
    }

    @Override
    public FieldInfos getFieldInfos() {
        return this.in.getFieldInfos();
    }

    @Override
    public PointsReader getPointsReader() {
        return this.in.getPointsReader();
    }

    @Override
    public KnnVectorsReader getVectorReader() {
        return this.in.getVectorReader();
    }

    @Override
    public int numDocs() {
        return this.in.numDocs();
    }

    @Override
    public int maxDoc() {
        return this.in.maxDoc();
    }

    @Override
    public LeafMetaData getMetaData() {
        return this.in.getMetaData();
    }

    @Override
    protected void doClose() throws IOException {
        this.in.doClose();
    }

    @Override
    public void checkIntegrity() throws IOException {
        this.in.checkIntegrity();
    }

    public CodecReader getDelegate() {
        return this.in;
    }

    static FilterCodecReader wrapLiveDocs(final CodecReader reader, final Bits liveDocs, final int numDocs) {
        return new FilterCodecReader(reader){

            @Override
            public IndexReader.CacheHelper getCoreCacheHelper() {
                return reader.getCoreCacheHelper();
            }

            @Override
            public IndexReader.CacheHelper getReaderCacheHelper() {
                return null;
            }

            @Override
            public Bits getLiveDocs() {
                return liveDocs;
            }

            @Override
            public int numDocs() {
                return numDocs;
            }
        };
    }
}

