/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.neo4j.shaded.lucene9.codecs.FieldsConsumer;
import org.neo4j.shaded.lucene9.codecs.NormsProducer;
import org.neo4j.shaded.lucene9.index.BufferedUpdates;
import org.neo4j.shaded.lucene9.index.FieldInfo;
import org.neo4j.shaded.lucene9.index.FieldInfos;
import org.neo4j.shaded.lucene9.index.FieldInvertState;
import org.neo4j.shaded.lucene9.index.Fields;
import org.neo4j.shaded.lucene9.index.FilterLeafReader;
import org.neo4j.shaded.lucene9.index.FreqProxFields;
import org.neo4j.shaded.lucene9.index.FreqProxTermsWriterPerField;
import org.neo4j.shaded.lucene9.index.FrozenBufferedUpdates;
import org.neo4j.shaded.lucene9.index.IndexOptions;
import org.neo4j.shaded.lucene9.index.PostingsEnum;
import org.neo4j.shaded.lucene9.index.SegmentWriteState;
import org.neo4j.shaded.lucene9.index.Sorter;
import org.neo4j.shaded.lucene9.index.Terms;
import org.neo4j.shaded.lucene9.index.TermsEnum;
import org.neo4j.shaded.lucene9.index.TermsHash;
import org.neo4j.shaded.lucene9.index.TermsHashPerField;
import org.neo4j.shaded.lucene9.search.DocIdSetIterator;
import org.neo4j.shaded.lucene9.store.ByteBuffersDataInput;
import org.neo4j.shaded.lucene9.store.ByteBuffersDataOutput;
import org.neo4j.shaded.lucene9.store.DataOutput;
import org.neo4j.shaded.lucene9.util.ArrayUtil;
import org.neo4j.shaded.lucene9.util.ByteBlockPool;
import org.neo4j.shaded.lucene9.util.BytesRef;
import org.neo4j.shaded.lucene9.util.CollectionUtil;
import org.neo4j.shaded.lucene9.util.Counter;
import org.neo4j.shaded.lucene9.util.FixedBitSet;
import org.neo4j.shaded.lucene9.util.IntBlockPool;
import org.neo4j.shaded.lucene9.util.IntsRef;
import org.neo4j.shaded.lucene9.util.LSBRadixSorter;
import org.neo4j.shaded.lucene9.util.LongsRef;
import org.neo4j.shaded.lucene9.util.TimSorter;
import org.neo4j.shaded.lucene9.util.automaton.CompiledAutomaton;
import org.neo4j.shaded.lucene9.util.packed.PackedInts;

final class FreqProxTermsWriter
extends TermsHash {
    FreqProxTermsWriter(IntBlockPool.Allocator intBlockAllocator, ByteBlockPool.Allocator byteBlockAllocator, Counter bytesUsed, TermsHash termVectors) {
        super(intBlockAllocator, byteBlockAllocator, bytesUsed, termVectors);
    }

    private void applyDeletes(SegmentWriteState state, Fields fields) throws IOException {
        if (state.segUpdates != null && state.segUpdates.deleteTerms.size() > 0) {
            BufferedUpdates.DeletedTerms segDeletes = state.segUpdates.deleteTerms;
            FrozenBufferedUpdates.TermDocsIterator iterator = new FrozenBufferedUpdates.TermDocsIterator(fields, true);
            segDeletes.forEachOrdered((term, docId) -> {
                DocIdSetIterator postings = iterator.nextTerm(term.field(), term.bytes());
                if (postings != null) {
                    int doc;
                    assert (docId < Integer.MAX_VALUE);
                    while ((doc = postings.nextDoc()) < docId) {
                        if (state.liveDocs == null) {
                            state.liveDocs = new FixedBitSet(state.segmentInfo.maxDoc());
                            state.liveDocs.set(0, state.segmentInfo.maxDoc());
                        }
                        if (!state.liveDocs.getAndClear(doc)) continue;
                        ++state.delCountOnFlush;
                    }
                }
            });
        }
    }

    @Override
    public void flush(Map<String, TermsHashPerField> fieldsToFlush, SegmentWriteState state, Sorter.DocMap sortMap, NormsProducer norms) throws IOException {
        super.flush(fieldsToFlush, state, sortMap, norms);
        ArrayList<FreqProxTermsWriterPerField> allFields = new ArrayList<FreqProxTermsWriterPerField>();
        for (TermsHashPerField f : fieldsToFlush.values()) {
            FreqProxTermsWriterPerField perField = (FreqProxTermsWriterPerField)f;
            if (perField.getNumTerms() <= 0) continue;
            perField.sortTerms();
            assert (perField.indexOptions != IndexOptions.NONE);
            allFields.add(perField);
        }
        if (!state.fieldInfos.hasPostings()) {
            assert (allFields.isEmpty());
            return;
        }
        CollectionUtil.introSort(allFields);
        Fields fields = new FreqProxFields(allFields);
        this.applyDeletes(state, fields);
        if (sortMap != null) {
            final Sorter.DocMap docMap = sortMap;
            final FieldInfos infos = state.fieldInfos;
            fields = new FilterLeafReader.FilterFields(fields){

                @Override
                public Terms terms(String field) throws IOException {
                    Terms terms = this.in.terms(field);
                    if (terms == null) {
                        return null;
                    }
                    return new SortingTerms(terms, infos.fieldInfo(field).getIndexOptions(), docMap);
                }
            };
        }
        try (FieldsConsumer consumer = state.segmentInfo.getCodec().postingsFormat().fieldsConsumer(state);){
            consumer.write(fields, norms);
        }
    }

    @Override
    public TermsHashPerField addField(FieldInvertState invertState, FieldInfo fieldInfo) {
        return new FreqProxTermsWriterPerField(invertState, this, fieldInfo, this.nextTermsHash.addField(invertState, fieldInfo));
    }

    static class SortingPostingsEnum
    extends PostingsEnum {
        private DocOffsetSorter sorter;
        private int[] docs = IntsRef.EMPTY_INTS;
        private long[] offsets = LongsRef.EMPTY_LONGS;
        private int upto;
        private ByteBuffersDataInput postingInput;
        private PostingsEnum in;
        private boolean storePositions;
        private boolean storeOffsets;
        private int docIt;
        private int pos;
        private int startOffset;
        private int endOffset;
        private final BytesRef payload = new BytesRef();
        private int currFreq;
        private final ByteBuffersDataOutput buffer = ByteBuffersDataOutput.newResettableInstance();

        SortingPostingsEnum() {
        }

        void reset(Sorter.DocMap docMap, PostingsEnum in, boolean storePositions, boolean storeOffsets) throws IOException {
            int doc;
            this.in = in;
            this.storePositions = storePositions;
            this.storeOffsets = storeOffsets;
            if (this.sorter == null) {
                int numTempSlots = docMap.size() / 8;
                this.sorter = new DocOffsetSorter(numTempSlots);
            }
            this.docIt = -1;
            this.startOffset = -1;
            this.endOffset = -1;
            this.buffer.reset();
            int i = 0;
            while ((doc = in.nextDoc()) != Integer.MAX_VALUE) {
                if (i == this.docs.length) {
                    int newLength = ArrayUtil.oversize(i + 1, 4);
                    this.docs = ArrayUtil.growExact(this.docs, newLength);
                    this.offsets = ArrayUtil.growExact(this.offsets, newLength);
                }
                this.docs[i] = docMap.oldToNew(doc);
                this.offsets[i] = this.buffer.size();
                this.addPositions(in, this.buffer);
                ++i;
            }
            this.upto = i;
            this.sorter.reset(this.docs, this.offsets);
            this.sorter.sort(0, this.upto);
            this.postingInput = this.buffer.toDataInput();
        }

        private void addPositions(PostingsEnum in, DataOutput out) throws IOException {
            int freq = in.freq();
            out.writeVInt(freq);
            if (this.storePositions) {
                int previousPosition = 0;
                int previousEndOffset = 0;
                for (int i = 0; i < freq; ++i) {
                    int pos = in.nextPosition();
                    BytesRef payload = in.getPayload();
                    int token = pos - previousPosition << 1 | (payload == null ? 0 : 1);
                    out.writeVInt(token);
                    previousPosition = pos;
                    if (this.storeOffsets) {
                        int startOffset = in.startOffset();
                        int endOffset = in.endOffset();
                        out.writeVInt(startOffset - previousEndOffset);
                        out.writeVInt(endOffset - startOffset);
                        previousEndOffset = endOffset;
                    }
                    if (payload == null) continue;
                    out.writeVInt(payload.length);
                    out.writeBytes(payload.bytes, payload.offset, payload.length);
                }
            }
        }

        @Override
        public int advance(int target) throws IOException {
            return this.slowAdvance(target);
        }

        @Override
        public int docID() {
            return this.docIt < 0 ? -1 : (this.docIt >= this.upto ? Integer.MAX_VALUE : this.docs[this.docIt]);
        }

        @Override
        public int endOffset() throws IOException {
            return this.endOffset;
        }

        @Override
        public int freq() throws IOException {
            return this.currFreq;
        }

        @Override
        public BytesRef getPayload() throws IOException {
            return this.payload.length == 0 ? null : this.payload;
        }

        @Override
        public int nextDoc() throws IOException {
            if (++this.docIt >= this.upto) {
                return Integer.MAX_VALUE;
            }
            this.postingInput.seek(this.offsets[this.docIt]);
            this.currFreq = this.postingInput.readVInt();
            this.pos = 0;
            this.endOffset = 0;
            return this.docs[this.docIt];
        }

        @Override
        public int nextPosition() throws IOException {
            if (!this.storePositions) {
                return -1;
            }
            int token = this.postingInput.readVInt();
            this.pos += token >>> 1;
            if (this.storeOffsets) {
                this.startOffset = this.endOffset + this.postingInput.readVInt();
                this.endOffset = this.startOffset + this.postingInput.readVInt();
            }
            if ((token & 1) != 0) {
                this.payload.offset = 0;
                this.payload.length = this.postingInput.readVInt();
                if (this.payload.length > this.payload.bytes.length) {
                    this.payload.bytes = new byte[ArrayUtil.oversize(this.payload.length, 1)];
                }
                this.postingInput.readBytes(this.payload.bytes, 0, this.payload.length);
            } else {
                this.payload.length = 0;
            }
            return this.pos;
        }

        @Override
        public int startOffset() throws IOException {
            return this.startOffset;
        }

        PostingsEnum getWrapped() {
            return this.in;
        }

        @Override
        public long cost() {
            return this.in.cost();
        }

        private static final class DocOffsetSorter
        extends TimSorter {
            private int[] docs;
            private long[] offsets;
            private int[] tmpDocs = IntsRef.EMPTY_INTS;
            private long[] tmpOffsets = LongsRef.EMPTY_LONGS;

            public DocOffsetSorter(int numTempSlots) {
                super(numTempSlots);
            }

            public void reset(int[] docs, long[] offsets) {
                this.docs = docs;
                this.offsets = offsets;
            }

            @Override
            protected int compare(int i, int j) {
                return this.docs[i] - this.docs[j];
            }

            @Override
            protected void swap(int i, int j) {
                int tmpDoc = this.docs[i];
                this.docs[i] = this.docs[j];
                this.docs[j] = tmpDoc;
                long tmpOffset = this.offsets[i];
                this.offsets[i] = this.offsets[j];
                this.offsets[j] = tmpOffset;
            }

            @Override
            protected void copy(int src, int dest) {
                this.docs[dest] = this.docs[src];
                this.offsets[dest] = this.offsets[src];
            }

            @Override
            protected void save(int i, int len) {
                if (this.tmpDocs.length < len) {
                    this.tmpDocs = new int[ArrayUtil.oversize(len, 4)];
                    this.tmpOffsets = new long[this.tmpDocs.length];
                }
                System.arraycopy(this.docs, i, this.tmpDocs, 0, len);
                System.arraycopy(this.offsets, i, this.tmpOffsets, 0, len);
            }

            @Override
            protected void restore(int i, int j) {
                this.docs[j] = this.tmpDocs[i];
                this.offsets[j] = this.tmpOffsets[i];
            }

            @Override
            protected int compareSaved(int i, int j) {
                return this.tmpDocs[i] - this.docs[j];
            }
        }
    }

    static class SortingDocsEnum
    extends PostingsEnum {
        private final LSBRadixSorter sorter;
        private PostingsEnum in;
        private int[] docs = IntsRef.EMPTY_INTS;
        private int docIt;
        private int upTo;

        SortingDocsEnum() {
            this.sorter = new LSBRadixSorter();
        }

        void reset(Sorter.DocMap docMap, PostingsEnum in) throws IOException {
            this.in = in;
            int i = 0;
            int doc = in.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                if (this.docs.length <= i) {
                    this.docs = ArrayUtil.grow(this.docs);
                }
                this.docs[i++] = docMap.oldToNew(doc);
                doc = in.nextDoc();
            }
            this.upTo = i;
            if (this.docs.length == this.upTo) {
                this.docs = ArrayUtil.grow(this.docs);
            }
            this.docs[this.upTo] = Integer.MAX_VALUE;
            int maxDoc = docMap.size();
            int numBits = PackedInts.bitsRequired(Math.max(0, maxDoc - 1));
            this.sorter.sort(numBits, this.docs, this.upTo);
            this.docIt = -1;
        }

        PostingsEnum getWrapped() {
            return this.in;
        }

        @Override
        public int advance(int target) throws IOException {
            return this.slowAdvance(target);
        }

        @Override
        public int docID() {
            return this.docIt < 0 ? -1 : this.docs[this.docIt];
        }

        @Override
        public int nextDoc() throws IOException {
            return this.docs[++this.docIt];
        }

        @Override
        public long cost() {
            return this.upTo;
        }

        @Override
        public int freq() throws IOException {
            return 1;
        }

        @Override
        public int nextPosition() throws IOException {
            return -1;
        }

        @Override
        public int startOffset() throws IOException {
            return -1;
        }

        @Override
        public int endOffset() throws IOException {
            return -1;
        }

        @Override
        public BytesRef getPayload() throws IOException {
            return null;
        }
    }

    private static class SortingTermsEnum
    extends FilterLeafReader.FilterTermsEnum {
        final Sorter.DocMap docMap;
        private final IndexOptions indexOptions;

        SortingTermsEnum(TermsEnum in, Sorter.DocMap docMap, IndexOptions indexOptions) {
            super(in);
            this.docMap = docMap;
            this.indexOptions = indexOptions;
        }

        @Override
        public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
            PostingsEnum inReuse;
            SortingDocsEnum wrapReuse;
            if (this.indexOptions.compareTo(IndexOptions.DOCS_AND_FREQS) >= 0 && PostingsEnum.featureRequested(flags, (short)8)) {
                PostingsEnum inReuse2;
                SortingPostingsEnum wrapReuse2;
                if (reuse != null && reuse instanceof SortingPostingsEnum) {
                    wrapReuse2 = (SortingPostingsEnum)reuse;
                    inReuse2 = wrapReuse2.getWrapped();
                } else {
                    wrapReuse2 = new SortingPostingsEnum();
                    inReuse2 = reuse;
                }
                PostingsEnum inDocsAndPositions = this.in.postings(inReuse2, flags);
                boolean storePositions = this.indexOptions.compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
                boolean storeOffsets = this.indexOptions.compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
                wrapReuse2.reset(this.docMap, inDocsAndPositions, storePositions, storeOffsets);
                return wrapReuse2;
            }
            if (reuse != null && reuse instanceof SortingDocsEnum) {
                wrapReuse = (SortingDocsEnum)reuse;
                inReuse = wrapReuse.getWrapped();
            } else {
                wrapReuse = new SortingDocsEnum();
                inReuse = reuse;
            }
            PostingsEnum inDocs = this.in.postings(inReuse, flags);
            wrapReuse.reset(this.docMap, inDocs);
            return wrapReuse;
        }
    }

    static class SortingTerms
    extends FilterLeafReader.FilterTerms {
        private final Sorter.DocMap docMap;
        private final IndexOptions indexOptions;

        SortingTerms(Terms in, IndexOptions indexOptions, Sorter.DocMap docMap) {
            super(in);
            this.docMap = docMap;
            this.indexOptions = indexOptions;
        }

        @Override
        public TermsEnum iterator() throws IOException {
            return new SortingTermsEnum(this.in.iterator(), this.docMap, this.indexOptions);
        }

        @Override
        public TermsEnum intersect(CompiledAutomaton compiled, BytesRef startTerm) throws IOException {
            return new SortingTermsEnum(this.in.intersect(compiled, startTerm), this.docMap, this.indexOptions);
        }
    }
}

