/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.index;

import java.io.IOException;
import java.util.Objects;
import org.neo4j.shaded.lucene9.codecs.Codec;
import org.neo4j.shaded.lucene9.codecs.StoredFieldsFormat;
import org.neo4j.shaded.lucene9.codecs.StoredFieldsReader;
import org.neo4j.shaded.lucene9.codecs.StoredFieldsWriter;
import org.neo4j.shaded.lucene9.codecs.compressing.CompressionMode;
import org.neo4j.shaded.lucene9.codecs.compressing.Compressor;
import org.neo4j.shaded.lucene9.codecs.compressing.Decompressor;
import org.neo4j.shaded.lucene9.codecs.lucene90.compressing.Lucene90CompressingStoredFieldsFormat;
import org.neo4j.shaded.lucene9.index.FieldInfo;
import org.neo4j.shaded.lucene9.index.SegmentInfo;
import org.neo4j.shaded.lucene9.index.SegmentWriteState;
import org.neo4j.shaded.lucene9.index.Sorter;
import org.neo4j.shaded.lucene9.index.StoredFieldVisitor;
import org.neo4j.shaded.lucene9.index.StoredFieldsConsumer;
import org.neo4j.shaded.lucene9.index.TrackingTmpOutputDirectoryWrapper;
import org.neo4j.shaded.lucene9.store.ByteBuffersDataInput;
import org.neo4j.shaded.lucene9.store.DataInput;
import org.neo4j.shaded.lucene9.store.DataOutput;
import org.neo4j.shaded.lucene9.store.Directory;
import org.neo4j.shaded.lucene9.store.IOContext;
import org.neo4j.shaded.lucene9.util.ArrayUtil;
import org.neo4j.shaded.lucene9.util.BytesRef;
import org.neo4j.shaded.lucene9.util.IOUtils;

final class SortingStoredFieldsConsumer
extends StoredFieldsConsumer {
    static final CompressionMode NO_COMPRESSION = new CompressionMode(){

        @Override
        public Compressor newCompressor() {
            return new Compressor(){

                @Override
                public void close() throws IOException {
                }

                @Override
                public void compress(ByteBuffersDataInput buffersInput, DataOutput out) throws IOException {
                    out.copyBytes(buffersInput, buffersInput.size());
                }
            };
        }

        @Override
        public Decompressor newDecompressor() {
            return new Decompressor(){

                @Override
                public void decompress(DataInput in, int originalLength, int offset, int length, BytesRef bytes) throws IOException {
                    bytes.bytes = ArrayUtil.growNoCopy(bytes.bytes, length);
                    in.skipBytes(offset);
                    in.readBytes(bytes.bytes, 0, length);
                    bytes.offset = 0;
                    bytes.length = length;
                }

                @Override
                public Decompressor clone() {
                    return this;
                }
            };
        }
    };
    private static final StoredFieldsFormat TEMP_STORED_FIELDS_FORMAT = new Lucene90CompressingStoredFieldsFormat("TempStoredFields", NO_COMPRESSION, 131072, 1, 10);
    TrackingTmpOutputDirectoryWrapper tmpDirectory;

    SortingStoredFieldsConsumer(Codec codec, Directory directory, SegmentInfo info) {
        super(codec, directory, info);
    }

    @Override
    protected void initStoredFieldsWriter() throws IOException {
        if (this.writer == null) {
            this.tmpDirectory = new TrackingTmpOutputDirectoryWrapper(this.directory);
            this.writer = TEMP_STORED_FIELDS_FORMAT.fieldsWriter(this.tmpDirectory, this.info, IOContext.DEFAULT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void flush(SegmentWriteState state, Sorter.DocMap sortMap) throws IOException {
        super.flush(state, sortMap);
        StoredFieldsReader reader = TEMP_STORED_FIELDS_FORMAT.fieldsReader(this.tmpDirectory, state.segmentInfo, state.fieldInfos, IOContext.DEFAULT);
        StoredFieldsWriter sortWriter = this.codec.storedFieldsFormat().fieldsWriter(state.directory, state.segmentInfo, state.context);
        try {
            reader.checkIntegrity();
            CopyVisitor visitor = new CopyVisitor(sortWriter);
            for (int docID = 0; docID < state.segmentInfo.maxDoc(); ++docID) {
                sortWriter.startDocument();
                reader.document(sortMap == null ? docID : sortMap.newToOld(docID), visitor);
                sortWriter.finishDocument();
            }
            sortWriter.finish(state.segmentInfo.maxDoc());
        }
        catch (Throwable throwable) {
            IOUtils.close(reader, sortWriter);
            IOUtils.deleteFiles(this.tmpDirectory, this.tmpDirectory.getTemporaryFiles().values());
            throw throwable;
        }
        IOUtils.close(reader, sortWriter);
        IOUtils.deleteFiles(this.tmpDirectory, this.tmpDirectory.getTemporaryFiles().values());
    }

    @Override
    void abort() {
        try {
            super.abort();
        }
        finally {
            if (this.tmpDirectory != null) {
                IOUtils.deleteFilesIgnoringExceptions((Directory)this.tmpDirectory, this.tmpDirectory.getTemporaryFiles().values());
            }
        }
    }

    private static class CopyVisitor
    extends StoredFieldVisitor {
        final StoredFieldsWriter writer;

        CopyVisitor(StoredFieldsWriter writer) {
            this.writer = writer;
        }

        @Override
        public void binaryField(FieldInfo fieldInfo, DataInput value, int length) throws IOException {
            this.writer.writeField(fieldInfo, value, length);
        }

        @Override
        public void binaryField(FieldInfo fieldInfo, byte[] value) throws IOException {
            this.writer.writeField(fieldInfo, new BytesRef(value));
        }

        @Override
        public void stringField(FieldInfo fieldInfo, String value) throws IOException {
            this.writer.writeField(fieldInfo, Objects.requireNonNull(value, "String value should not be null"));
        }

        @Override
        public void intField(FieldInfo fieldInfo, int value) throws IOException {
            this.writer.writeField(fieldInfo, value);
        }

        @Override
        public void longField(FieldInfo fieldInfo, long value) throws IOException {
            this.writer.writeField(fieldInfo, value);
        }

        @Override
        public void floatField(FieldInfo fieldInfo, float value) throws IOException {
            this.writer.writeField(fieldInfo, value);
        }

        @Override
        public void doubleField(FieldInfo fieldInfo, double value) throws IOException {
            this.writer.writeField(fieldInfo, value);
        }

        @Override
        public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
            return StoredFieldVisitor.Status.YES;
        }
    }
}

