/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.index;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.neo4j.shaded.lucene9.codecs.Codec;
import org.neo4j.shaded.lucene9.codecs.NormsProducer;
import org.neo4j.shaded.lucene9.codecs.TermVectorsFormat;
import org.neo4j.shaded.lucene9.codecs.TermVectorsReader;
import org.neo4j.shaded.lucene9.codecs.TermVectorsWriter;
import org.neo4j.shaded.lucene9.codecs.lucene90.compressing.Lucene90CompressingTermVectorsFormat;
import org.neo4j.shaded.lucene9.index.FieldInfo;
import org.neo4j.shaded.lucene9.index.FieldInfos;
import org.neo4j.shaded.lucene9.index.Fields;
import org.neo4j.shaded.lucene9.index.PostingsEnum;
import org.neo4j.shaded.lucene9.index.SegmentInfo;
import org.neo4j.shaded.lucene9.index.SegmentWriteState;
import org.neo4j.shaded.lucene9.index.Sorter;
import org.neo4j.shaded.lucene9.index.SortingStoredFieldsConsumer;
import org.neo4j.shaded.lucene9.index.TermVectorsConsumer;
import org.neo4j.shaded.lucene9.index.Terms;
import org.neo4j.shaded.lucene9.index.TermsEnum;
import org.neo4j.shaded.lucene9.index.TermsHashPerField;
import org.neo4j.shaded.lucene9.index.TrackingTmpOutputDirectoryWrapper;
import org.neo4j.shaded.lucene9.store.Directory;
import org.neo4j.shaded.lucene9.store.FlushInfo;
import org.neo4j.shaded.lucene9.store.IOContext;
import org.neo4j.shaded.lucene9.util.ByteBlockPool;
import org.neo4j.shaded.lucene9.util.BytesRef;
import org.neo4j.shaded.lucene9.util.IOUtils;
import org.neo4j.shaded.lucene9.util.IntBlockPool;

final class SortingTermVectorsConsumer
extends TermVectorsConsumer {
    private static final TermVectorsFormat TEMP_TERM_VECTORS_FORMAT = new Lucene90CompressingTermVectorsFormat("TempTermVectors", "", SortingStoredFieldsConsumer.NO_COMPRESSION, 8192, 128, 10);
    TrackingTmpOutputDirectoryWrapper tmpDirectory;

    SortingTermVectorsConsumer(IntBlockPool.Allocator intBlockAllocator, ByteBlockPool.Allocator byteBlockAllocator, Directory directory, SegmentInfo info, Codec codec) {
        super(intBlockAllocator, byteBlockAllocator, directory, info, codec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void flush(Map<String, TermsHashPerField> fieldsToFlush, SegmentWriteState state, Sorter.DocMap sortMap, NormsProducer norms) throws IOException {
        super.flush(fieldsToFlush, state, sortMap, norms);
        if (this.tmpDirectory != null) {
            TermVectorsReader reader = TEMP_TERM_VECTORS_FORMAT.vectorsReader(this.tmpDirectory, state.segmentInfo, state.fieldInfos, IOContext.DEFAULT);
            TermVectorsWriter writer = this.codec.termVectorsFormat().vectorsWriter(state.directory, state.segmentInfo, state.context);
            try {
                reader.checkIntegrity();
                for (int docID = 0; docID < state.segmentInfo.maxDoc(); ++docID) {
                    Fields vectors = reader.get(sortMap == null ? docID : sortMap.newToOld(docID));
                    SortingTermVectorsConsumer.writeTermVectors(writer, vectors, state.fieldInfos);
                }
                writer.finish(state.segmentInfo.maxDoc());
            }
            catch (Throwable throwable) {
                IOUtils.close(reader, writer);
                IOUtils.deleteFiles(this.tmpDirectory, this.tmpDirectory.getTemporaryFiles().values());
                throw throwable;
            }
            IOUtils.close(reader, writer);
            IOUtils.deleteFiles(this.tmpDirectory, this.tmpDirectory.getTemporaryFiles().values());
        }
    }

    @Override
    void initTermVectorsWriter() throws IOException {
        if (this.writer == null) {
            IOContext context = new IOContext(new FlushInfo(this.lastDocID, this.bytesUsed.get()));
            this.tmpDirectory = new TrackingTmpOutputDirectoryWrapper(this.directory);
            this.writer = TEMP_TERM_VECTORS_FORMAT.vectorsWriter(this.tmpDirectory, this.info, context);
            this.lastDocID = 0;
        }
    }

    @Override
    public void abort() {
        try {
            super.abort();
        }
        finally {
            if (this.tmpDirectory != null) {
                IOUtils.deleteFilesIgnoringExceptions((Directory)this.tmpDirectory, this.tmpDirectory.getTemporaryFiles().values());
            }
        }
    }

    private static void writeTermVectors(TermVectorsWriter writer, Fields vectors, FieldInfos fieldInfos) throws IOException {
        if (vectors == null) {
            writer.startDocument(0);
            writer.finishDocument();
            return;
        }
        int numFields = vectors.size();
        if (numFields == -1) {
            numFields = 0;
            Iterator<String> it = vectors.iterator();
            while (it.hasNext()) {
                it.next();
                ++numFields;
            }
        }
        writer.startDocument(numFields);
        String lastFieldName = null;
        TermsEnum termsEnum = null;
        PostingsEnum docsAndPositionsEnum = null;
        int fieldCount = 0;
        for (String fieldName : vectors) {
            ++fieldCount;
            FieldInfo fieldInfo = fieldInfos.fieldInfo(fieldName);
            assert (lastFieldName == null || fieldName.compareTo(lastFieldName) > 0) : "lastFieldName=" + lastFieldName + " fieldName=" + fieldName;
            lastFieldName = fieldName;
            Terms terms = vectors.terms(fieldName);
            if (terms == null) continue;
            boolean hasPositions = terms.hasPositions();
            boolean hasOffsets = terms.hasOffsets();
            boolean hasPayloads = terms.hasPayloads();
            assert (!hasPayloads || hasPositions);
            int numTerms = (int)terms.size();
            if (numTerms == -1) {
                numTerms = 0;
                termsEnum = terms.iterator();
                while (termsEnum.next() != null) {
                    ++numTerms;
                }
            }
            writer.startField(fieldInfo, numTerms, hasPositions, hasOffsets, hasPayloads);
            termsEnum = terms.iterator();
            int termCount = 0;
            while (termsEnum.next() != null) {
                ++termCount;
                int freq = (int)termsEnum.totalTermFreq();
                writer.startTerm(termsEnum.term(), freq);
                if (hasPositions || hasOffsets) {
                    docsAndPositionsEnum = termsEnum.postings(docsAndPositionsEnum, 120);
                    assert (docsAndPositionsEnum != null);
                    int docID = docsAndPositionsEnum.nextDoc();
                    assert (docID != Integer.MAX_VALUE);
                    assert (docsAndPositionsEnum.freq() == freq);
                    for (int posUpto = 0; posUpto < freq; ++posUpto) {
                        int pos = docsAndPositionsEnum.nextPosition();
                        int startOffset = docsAndPositionsEnum.startOffset();
                        int endOffset = docsAndPositionsEnum.endOffset();
                        BytesRef payload = docsAndPositionsEnum.getPayload();
                        assert (!hasPositions || pos >= 0);
                        writer.addPosition(pos, startOffset, endOffset, payload);
                    }
                }
                writer.finishTerm();
            }
            assert (termCount == numTerms);
            writer.finishField();
        }
        assert (fieldCount == numFields);
        writer.finishDocument();
    }
}

