/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.internal.hppc;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.neo4j.shaded.lucene9.internal.hppc.AbstractIterator;
import org.neo4j.shaded.lucene9.internal.hppc.BitMixer;
import org.neo4j.shaded.lucene9.internal.hppc.BufferAllocationException;
import org.neo4j.shaded.lucene9.internal.hppc.HashContainers;
import org.neo4j.shaded.lucene9.internal.hppc.IntCursor;
import org.neo4j.shaded.lucene9.util.Accountable;
import org.neo4j.shaded.lucene9.util.RamUsageEstimator;

public class IntHashSet
implements Iterable<IntCursor>,
Accountable,
Cloneable {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(IntHashSet.class);
    public int[] keys;
    protected int assigned;
    protected int mask;
    protected int resizeAt;
    protected boolean hasEmptyKey;
    protected double loadFactor;
    protected int iterationSeed;

    public IntHashSet() {
        this(4);
    }

    public IntHashSet(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public IntHashSet(int expectedElements, double loadFactor) {
        this.loadFactor = this.verifyLoadFactor(loadFactor);
        this.iterationSeed = HashContainers.ITERATION_SEED.incrementAndGet();
        this.ensureCapacity(expectedElements);
    }

    public IntHashSet(IntHashSet set) {
        this(set.size());
        this.addAll(set);
    }

    public IntHashSet(Collection<Integer> collection) {
        this(collection.size());
        this.addAll(collection);
    }

    public boolean add(int key) {
        int existing;
        if (key == 0) {
            assert (this.keys[this.mask + 1] == 0);
            boolean added = !this.hasEmptyKey;
            this.hasEmptyKey = true;
            return added;
        }
        int[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0) {
            if (key == existing) {
                return false;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(slot, key);
        } else {
            keys[slot] = key;
        }
        ++this.assigned;
        return true;
    }

    public final int addAll(int ... elements) {
        this.ensureCapacity(elements.length);
        int count = 0;
        for (int e : elements) {
            if (!this.add(e)) continue;
            ++count;
        }
        return count;
    }

    public int addAll(IntHashSet set) {
        this.ensureCapacity(set.size());
        return this.addAll((Iterable<? extends IntCursor>)set);
    }

    public int addAll(Iterable<? extends IntCursor> iterable) {
        int count = 0;
        for (IntCursor intCursor : iterable) {
            if (!this.add(intCursor.value)) continue;
            ++count;
        }
        return count;
    }

    public int addAll(Collection<Integer> collection) {
        int count = 0;
        for (int element : collection) {
            if (!this.add(element)) continue;
            ++count;
        }
        return count;
    }

    public int[] toArray() {
        int[] cloned = new int[this.size()];
        int j = 0;
        if (this.hasEmptyKey) {
            cloned[j++] = 0;
        }
        int[] keys = this.keys;
        int seed = this.nextIterationSeed();
        int inc = HashContainers.iterationIncrement(seed);
        int mask = this.mask;
        int slot = seed & mask;
        for (int i = 0; i <= mask; ++i) {
            int existing = keys[slot];
            if (existing != 0) {
                cloned[j++] = existing;
            }
            slot = slot + inc & mask;
        }
        return cloned;
    }

    public boolean remove(int key) {
        int existing;
        if (key == 0) {
            boolean hadEmptyKey = this.hasEmptyKey;
            this.hasEmptyKey = false;
            return hadEmptyKey;
        }
        int[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0) {
            if (key == existing) {
                this.shiftConflictingKeys(slot);
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    public int removeAll(IntHashSet other) {
        int before = this.size();
        if (other.size() >= this.size()) {
            if (this.hasEmptyKey && other.contains(0)) {
                this.hasEmptyKey = false;
            }
            int[] keys = this.keys;
            int slot = 0;
            int max = this.mask;
            while (slot <= max) {
                int existing = keys[slot];
                if (existing != 0 && other.contains(existing)) {
                    this.shiftConflictingKeys(slot);
                    continue;
                }
                ++slot;
            }
        } else {
            for (IntCursor c : other) {
                this.remove(c.value);
            }
        }
        return before - this.size();
    }

    public boolean contains(int key) {
        int existing;
        if (key == 0) {
            return this.hasEmptyKey;
        }
        int[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0) {
            if (key == existing) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, 0);
    }

    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.ensureCapacity(4);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public void ensureCapacity(int expectedElements) {
        if (expectedElements > this.resizeAt || this.keys == null) {
            int[] prevKeys = this.keys;
            this.allocateBuffers(HashContainers.minBufferSize(expectedElements, this.loadFactor));
            if (prevKeys != null && !this.isEmpty()) {
                this.rehash(prevKeys);
            }
        }
    }

    public int size() {
        return this.assigned + (this.hasEmptyKey ? 1 : 0);
    }

    public int hashCode() {
        int h = this.hasEmptyKey ? -559038737 : 0;
        int[] keys = this.keys;
        for (int slot = this.mask; slot >= 0; --slot) {
            int existing = keys[slot];
            if (existing == 0) continue;
            h += BitMixer.mix(existing);
        }
        return h;
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && this.getClass() == obj.getClass() && this.sameKeys((IntHashSet)this.getClass().cast(obj));
    }

    private boolean sameKeys(IntHashSet other) {
        if (other.size() != this.size()) {
            return false;
        }
        for (IntCursor c : other) {
            if (this.contains(c.value)) continue;
            return false;
        }
        return true;
    }

    public IntHashSet clone() {
        try {
            IntHashSet cloned = (IntHashSet)super.clone();
            cloned.keys = (int[])this.keys.clone();
            cloned.hasEmptyKey = this.hasEmptyKey;
            cloned.iterationSeed = HashContainers.ITERATION_SEED.incrementAndGet();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Iterator<IntCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf(this.keys);
    }

    protected int nextIterationSeed() {
        this.iterationSeed = BitMixer.mixPhi(this.iterationSeed);
        return this.iterationSeed;
    }

    public static IntHashSet from(int ... elements) {
        IntHashSet set = new IntHashSet(elements.length);
        set.addAll(elements);
        return set;
    }

    protected int hashKey(int key) {
        assert (key != 0);
        return BitMixer.mixPhi(key);
    }

    public int indexOf(int key) {
        int existing;
        int mask = this.mask;
        if (key == 0) {
            return this.hasEmptyKey ? mask + 1 : ~(mask + 1);
        }
        int[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0) {
            if (key == existing) {
                return slot;
            }
            slot = slot + 1 & mask;
        }
        return ~slot;
    }

    public boolean indexExists(int index) {
        assert (index < 0 || index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        return index >= 0;
    }

    public int indexGet(int index) {
        assert (index >= 0) : "The index must point at an existing key.";
        assert (index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        return this.keys[index];
    }

    public int indexReplace(int index, int equivalentKey) {
        assert (index >= 0) : "The index must point at an existing key.";
        assert (index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        assert (this.keys[index] == equivalentKey);
        int previousValue = this.keys[index];
        this.keys[index] = equivalentKey;
        return previousValue;
    }

    public void indexInsert(int index, int key) {
        assert (index < 0) : "The index must not point at an existing key.";
        index ^= 0xFFFFFFFF;
        if (key == 0) {
            assert (index == this.mask + 1);
            assert (this.keys[index] == 0);
            this.hasEmptyKey = true;
        } else {
            assert (this.keys[index] == 0);
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(index, key);
            } else {
                this.keys[index] = key;
            }
            ++this.assigned;
        }
    }

    public void indexRemove(int index) {
        assert (index >= 0) : "The index must point at an existing key.";
        assert (index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        if (index > this.mask) {
            this.hasEmptyKey = false;
        } else {
            this.shiftConflictingKeys(index);
        }
    }

    protected double verifyLoadFactor(double loadFactor) {
        HashContainers.checkLoadFactor(loadFactor, 0.01f, 0.99f);
        return loadFactor;
    }

    protected void rehash(int[] fromKeys) {
        assert (HashContainers.checkPowerOfTwo(fromKeys.length - 1));
        int[] keys = this.keys;
        int mask = this.mask;
        int i = fromKeys.length - 1;
        while (--i >= 0) {
            int existing = fromKeys[i];
            if (existing == 0) continue;
            int slot = this.hashKey(existing) & mask;
            while (keys[slot] != 0) {
                slot = slot + 1 & mask;
            }
            keys[slot] = existing;
        }
    }

    protected void allocateBuffers(int arraySize) {
        assert (Integer.bitCount(arraySize) == 1);
        int[] prevKeys = this.keys;
        try {
            int emptyElementSlot = 1;
            this.keys = new int[arraySize + emptyElementSlot];
        }
        catch (OutOfMemoryError e) {
            this.keys = prevKeys;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)e, this.keys == null ? 0 : this.size(), arraySize);
        }
        this.resizeAt = HashContainers.expandAtCount(arraySize, this.loadFactor);
        this.mask = arraySize - 1;
    }

    protected void allocateThenInsertThenRehash(int slot, int pendingKey) {
        assert (this.assigned == this.resizeAt && this.keys[slot] == 0 && pendingKey != 0);
        int[] prevKeys = this.keys;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        assert (this.keys.length > prevKeys.length);
        prevKeys[slot] = pendingKey;
        this.rehash(prevKeys);
    }

    protected void shiftConflictingKeys(int gapSlot) {
        int slot;
        int existing;
        int[] keys = this.keys;
        int mask = this.mask;
        int distance = 0;
        while ((existing = keys[slot = gapSlot + ++distance & mask]) != 0) {
            int idealSlot = this.hashKey(existing);
            int shift = slot - idealSlot & mask;
            if (shift < distance) continue;
            keys[gapSlot] = existing;
            gapSlot = slot;
            distance = 0;
        }
        keys[gapSlot] = 0;
        --this.assigned;
    }

    protected final class EntryIterator
    extends AbstractIterator<IntCursor> {
        private final IntCursor cursor = new IntCursor();
        private final int increment;
        private int index;
        private int slot;

        public EntryIterator() {
            int seed = IntHashSet.this.nextIterationSeed();
            this.increment = HashContainers.iterationIncrement(seed);
            this.slot = seed & IntHashSet.this.mask;
        }

        @Override
        protected IntCursor fetch() {
            int mask = IntHashSet.this.mask;
            while (this.index <= mask) {
                ++this.index;
                this.slot = this.slot + this.increment & mask;
                int existing = IntHashSet.this.keys[this.slot];
                if (existing == 0) continue;
                this.cursor.index = this.slot;
                this.cursor.value = existing;
                return this.cursor;
            }
            if (this.index == mask + 1 && IntHashSet.this.hasEmptyKey) {
                this.cursor.index = this.index++;
                this.cursor.value = 0;
                return this.cursor;
            }
            return (IntCursor)this.done();
        }
    }
}

