/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.internal.hppc;

import java.util.Arrays;
import java.util.Iterator;
import org.neo4j.shaded.lucene9.internal.hppc.AbstractIterator;
import org.neo4j.shaded.lucene9.internal.hppc.BitMixer;
import org.neo4j.shaded.lucene9.internal.hppc.BufferAllocationException;
import org.neo4j.shaded.lucene9.internal.hppc.HashContainers;
import org.neo4j.shaded.lucene9.internal.hppc.IntCursor;
import org.neo4j.shaded.lucene9.internal.hppc.LongCursor;
import org.neo4j.shaded.lucene9.util.Accountable;
import org.neo4j.shaded.lucene9.util.RamUsageEstimator;

public class IntLongHashMap
implements Iterable<IntLongCursor>,
Accountable,
Cloneable {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(IntLongHashMap.class);
    public int[] keys;
    public long[] values;
    protected int assigned;
    protected int mask;
    protected int resizeAt;
    protected boolean hasEmptyKey;
    protected double loadFactor;
    protected int iterationSeed;

    public IntLongHashMap() {
        this(4);
    }

    public IntLongHashMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public IntLongHashMap(int expectedElements, double loadFactor) {
        this.loadFactor = this.verifyLoadFactor(loadFactor);
        this.iterationSeed = HashContainers.ITERATION_SEED.incrementAndGet();
        this.ensureCapacity(expectedElements);
    }

    public IntLongHashMap(IntLongHashMap container) {
        this(container.size());
        this.putAll(container);
    }

    public long put(int key, long value) {
        int existing;
        assert (this.assigned < this.mask + 1);
        int mask = this.mask;
        if (key == 0) {
            long previousValue = this.hasEmptyKey ? this.values[mask + 1] : 0L;
            this.hasEmptyKey = true;
            this.values[mask + 1] = value;
            return previousValue;
        }
        int[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0) {
            if (key == existing) {
                long previousValue = this.values[slot];
                this.values[slot] = value;
                return previousValue;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(slot, key, value);
        } else {
            keys[slot] = key;
            this.values[slot] = value;
        }
        ++this.assigned;
        return 0L;
    }

    public boolean putIfAbsent(int key, long value) {
        int keyIndex = this.indexOf(key);
        if (this.indexExists(keyIndex)) {
            return false;
        }
        this.indexInsert(keyIndex, key, value);
        return true;
    }

    public int putAll(Iterable<? extends IntLongCursor> iterable) {
        int count = this.size();
        for (IntLongCursor intLongCursor : iterable) {
            this.put(intLongCursor.key, intLongCursor.value);
        }
        return this.size() - count;
    }

    public long putOrAdd(int key, long putValue, long incrementValue) {
        assert (this.assigned < this.mask + 1);
        int keyIndex = this.indexOf(key);
        if (this.indexExists(keyIndex)) {
            putValue = this.values[keyIndex] + incrementValue;
            this.indexReplace(keyIndex, putValue);
        } else {
            this.indexInsert(keyIndex, key, putValue);
        }
        return putValue;
    }

    public long addTo(int key, long incrementValue) {
        return this.putOrAdd(key, incrementValue, incrementValue);
    }

    public long remove(int key) {
        int existing;
        int mask = this.mask;
        if (key == 0) {
            if (!this.hasEmptyKey) {
                return 0L;
            }
            this.hasEmptyKey = false;
            long previousValue = this.values[mask + 1];
            this.values[mask + 1] = 0L;
            return previousValue;
        }
        int[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0) {
            if (key == existing) {
                long previousValue = this.values[slot];
                this.shiftConflictingKeys(slot);
                return previousValue;
            }
            slot = slot + 1 & mask;
        }
        return 0L;
    }

    public long get(int key) {
        int existing;
        if (key == 0) {
            return this.hasEmptyKey ? this.values[this.mask + 1] : 0L;
        }
        int[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0) {
            if (key == existing) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return 0L;
    }

    public long getOrDefault(int key, long defaultValue) {
        int existing;
        if (key == 0) {
            return this.hasEmptyKey ? this.values[this.mask + 1] : defaultValue;
        }
        int[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0) {
            if (key == existing) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return defaultValue;
    }

    public boolean containsKey(int key) {
        int existing;
        if (key == 0) {
            return this.hasEmptyKey;
        }
        int[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0) {
            if (key == existing) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    public int indexOf(int key) {
        int existing;
        int mask = this.mask;
        if (key == 0) {
            return this.hasEmptyKey ? mask + 1 : ~(mask + 1);
        }
        int[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0) {
            if (key == existing) {
                return slot;
            }
            slot = slot + 1 & mask;
        }
        return ~slot;
    }

    public boolean indexExists(int index) {
        assert (index < 0 || index >= 0 && index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        return index >= 0;
    }

    public long indexGet(int index) {
        assert (index >= 0) : "The index must point at an existing key.";
        assert (index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        return this.values[index];
    }

    public long indexReplace(int index, long newValue) {
        assert (index >= 0) : "The index must point at an existing key.";
        assert (index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        long previousValue = this.values[index];
        this.values[index] = newValue;
        return previousValue;
    }

    public void indexInsert(int index, int key, long value) {
        assert (index < 0) : "The index must not point at an existing key.";
        index ^= 0xFFFFFFFF;
        if (key == 0) {
            assert (index == this.mask + 1);
            this.values[index] = value;
            this.hasEmptyKey = true;
        } else {
            assert (this.keys[index] == 0);
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(index, key, value);
            } else {
                this.keys[index] = key;
                this.values[index] = value;
            }
            ++this.assigned;
        }
    }

    public long indexRemove(int index) {
        assert (index >= 0) : "The index must point at an existing key.";
        assert (index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        long previousValue = this.values[index];
        if (index > this.mask) {
            assert (index == this.mask + 1);
            this.hasEmptyKey = false;
            this.values[index] = 0L;
        } else {
            this.shiftConflictingKeys(index);
        }
        return previousValue;
    }

    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, 0);
    }

    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    public int size() {
        return this.assigned + (this.hasEmptyKey ? 1 : 0);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int hashCode() {
        int h = this.hasEmptyKey ? -559038737 : 0;
        for (IntLongCursor c : this) {
            h += BitMixer.mix(c.key) + BitMixer.mix(c.value);
        }
        return h;
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && this.getClass() == obj.getClass() && this.equalElements((IntLongHashMap)this.getClass().cast(obj));
    }

    protected boolean equalElements(IntLongHashMap other) {
        if (other.size() != this.size()) {
            return false;
        }
        for (IntLongCursor c : other) {
            int key = c.key;
            if (this.containsKey(key) && c.value == this.get(key)) continue;
            return false;
        }
        return true;
    }

    public void ensureCapacity(int expectedElements) {
        if (expectedElements > this.resizeAt || this.keys == null) {
            int[] prevKeys = this.keys;
            long[] prevValues = this.values;
            this.allocateBuffers(HashContainers.minBufferSize(expectedElements, this.loadFactor));
            if (prevKeys != null && !this.isEmpty()) {
                this.rehash(prevKeys, prevValues);
            }
        }
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf(this.keys) + RamUsageEstimator.sizeOf(this.values);
    }

    protected int nextIterationSeed() {
        this.iterationSeed = BitMixer.mixPhi(this.iterationSeed);
        return this.iterationSeed;
    }

    @Override
    public Iterator<IntLongCursor> iterator() {
        return new EntryIterator();
    }

    public KeysContainer keys() {
        return new KeysContainer();
    }

    public ValuesContainer values() {
        return new ValuesContainer();
    }

    public IntLongHashMap clone() {
        try {
            IntLongHashMap cloned = (IntLongHashMap)super.clone();
            cloned.keys = (int[])this.keys.clone();
            cloned.values = (long[])this.values.clone();
            cloned.hasEmptyKey = this.hasEmptyKey;
            cloned.iterationSeed = HashContainers.ITERATION_SEED.incrementAndGet();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (IntLongCursor cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static IntLongHashMap from(int[] keys, long[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        IntLongHashMap map = new IntLongHashMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    protected int hashKey(int key) {
        assert (key != 0);
        return BitMixer.mixPhi(key);
    }

    protected double verifyLoadFactor(double loadFactor) {
        HashContainers.checkLoadFactor(loadFactor, 0.01f, 0.99f);
        return loadFactor;
    }

    protected void rehash(int[] fromKeys, long[] fromValues) {
        assert (fromKeys.length == fromValues.length && HashContainers.checkPowerOfTwo(fromKeys.length - 1));
        int[] keys = this.keys;
        long[] values = this.values;
        int mask = this.mask;
        int from = fromKeys.length - 1;
        keys[keys.length - 1] = fromKeys[from];
        values[values.length - 1] = fromValues[from];
        while (--from >= 0) {
            int existing = fromKeys[from];
            if (existing == 0) continue;
            int slot = this.hashKey(existing) & mask;
            while (keys[slot] != 0) {
                slot = slot + 1 & mask;
            }
            keys[slot] = existing;
            values[slot] = fromValues[from];
        }
    }

    protected void allocateBuffers(int arraySize) {
        assert (Integer.bitCount(arraySize) == 1);
        int[] prevKeys = this.keys;
        long[] prevValues = this.values;
        try {
            int emptyElementSlot = 1;
            this.keys = new int[arraySize + emptyElementSlot];
            this.values = new long[arraySize + emptyElementSlot];
        }
        catch (OutOfMemoryError e) {
            this.keys = prevKeys;
            this.values = prevValues;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)e, this.mask + 1, arraySize);
        }
        this.resizeAt = HashContainers.expandAtCount(arraySize, this.loadFactor);
        this.mask = arraySize - 1;
    }

    protected void allocateThenInsertThenRehash(int slot, int pendingKey, long pendingValue) {
        assert (this.assigned == this.resizeAt && this.keys[slot] == 0 && pendingKey != 0);
        int[] prevKeys = this.keys;
        long[] prevValues = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        assert (this.keys.length > prevKeys.length);
        prevKeys[slot] = pendingKey;
        prevValues[slot] = pendingValue;
        this.rehash(prevKeys, prevValues);
    }

    protected void shiftConflictingKeys(int gapSlot) {
        int slot;
        int existing;
        int[] keys = this.keys;
        long[] values = this.values;
        int mask = this.mask;
        int distance = 0;
        while ((existing = keys[slot = gapSlot + ++distance & mask]) != 0) {
            int idealSlot = this.hashKey(existing);
            int shift = slot - idealSlot & mask;
            if (shift < distance) continue;
            keys[gapSlot] = existing;
            values[gapSlot] = values[slot];
            gapSlot = slot;
            distance = 0;
        }
        keys[gapSlot] = 0;
        values[gapSlot] = 0L;
        --this.assigned;
    }

    public static final class IntLongCursor {
        public int index;
        public int key;
        public long value;

        public String toString() {
            return "[cursor, index: " + this.index + ", key: " + this.key + ", value: " + this.value + "]";
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<LongCursor> {
        private final LongCursor cursor = new LongCursor();
        private final int increment;
        private int index;
        private int slot;

        public ValuesIterator() {
            int seed = IntLongHashMap.this.nextIterationSeed();
            this.increment = HashContainers.iterationIncrement(seed);
            this.slot = seed & IntLongHashMap.this.mask;
        }

        @Override
        protected LongCursor fetch() {
            int mask = IntLongHashMap.this.mask;
            while (this.index <= mask) {
                ++this.index;
                this.slot = this.slot + this.increment & mask;
                if (IntLongHashMap.this.keys[this.slot] == 0) continue;
                this.cursor.index = this.slot;
                this.cursor.value = IntLongHashMap.this.values[this.slot];
                return this.cursor;
            }
            if (this.index == mask + 1 && IntLongHashMap.this.hasEmptyKey) {
                this.cursor.index = this.index;
                this.cursor.value = IntLongHashMap.this.values[this.index++];
                return this.cursor;
            }
            return (LongCursor)this.done();
        }
    }

    public final class ValuesContainer
    implements Iterable<LongCursor> {
        @Override
        public Iterator<LongCursor> iterator() {
            return new ValuesIterator();
        }

        public long[] toArray() {
            long[] array = new long[IntLongHashMap.this.size()];
            int i = 0;
            for (LongCursor cursor : this) {
                array[i++] = cursor.value;
            }
            return array;
        }
    }

    private final class KeysIterator
    extends AbstractIterator<IntCursor> {
        private final IntCursor cursor = new IntCursor();
        private final int increment;
        private int index;
        private int slot;

        public KeysIterator() {
            int seed = IntLongHashMap.this.nextIterationSeed();
            this.increment = HashContainers.iterationIncrement(seed);
            this.slot = seed & IntLongHashMap.this.mask;
        }

        @Override
        protected IntCursor fetch() {
            int mask = IntLongHashMap.this.mask;
            while (this.index <= mask) {
                ++this.index;
                this.slot = this.slot + this.increment & mask;
                int existing = IntLongHashMap.this.keys[this.slot];
                if (existing == 0) continue;
                this.cursor.index = this.slot;
                this.cursor.value = existing;
                return this.cursor;
            }
            if (this.index == mask + 1 && IntLongHashMap.this.hasEmptyKey) {
                this.cursor.index = this.index++;
                this.cursor.value = 0;
                return this.cursor;
            }
            return (IntCursor)this.done();
        }
    }

    public final class KeysContainer
    implements Iterable<IntCursor> {
        @Override
        public Iterator<IntCursor> iterator() {
            return new KeysIterator();
        }

        public int size() {
            return IntLongHashMap.this.size();
        }

        public int[] toArray() {
            int[] array = new int[this.size()];
            int i = 0;
            for (IntCursor cursor : this) {
                array[i++] = cursor.value;
            }
            return array;
        }
    }

    private final class EntryIterator
    extends AbstractIterator<IntLongCursor> {
        private final IntLongCursor cursor = new IntLongCursor();
        private final int increment;
        private int index;
        private int slot;

        public EntryIterator() {
            int seed = IntLongHashMap.this.nextIterationSeed();
            this.increment = HashContainers.iterationIncrement(seed);
            this.slot = seed & IntLongHashMap.this.mask;
        }

        @Override
        protected IntLongCursor fetch() {
            int mask = IntLongHashMap.this.mask;
            while (this.index <= mask) {
                ++this.index;
                this.slot = this.slot + this.increment & mask;
                int existing = IntLongHashMap.this.keys[this.slot];
                if (existing == 0) continue;
                this.cursor.index = this.slot;
                this.cursor.key = existing;
                this.cursor.value = IntLongHashMap.this.values[this.slot];
                return this.cursor;
            }
            if (this.index == mask + 1 && IntLongHashMap.this.hasEmptyKey) {
                this.cursor.index = this.index;
                this.cursor.key = 0;
                this.cursor.value = IntLongHashMap.this.values[this.index++];
                return this.cursor;
            }
            return (IntLongCursor)this.done();
        }
    }
}

