/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.queryparser.flexible.standard.builders;

import java.util.List;
import org.neo4j.shaded.lucene9.queryparser.flexible.core.QueryNodeException;
import org.neo4j.shaded.lucene9.queryparser.flexible.core.builders.QueryTreeBuilder;
import org.neo4j.shaded.lucene9.queryparser.flexible.core.messages.QueryParserMessages;
import org.neo4j.shaded.lucene9.queryparser.flexible.core.nodes.AnyQueryNode;
import org.neo4j.shaded.lucene9.queryparser.flexible.core.nodes.QueryNode;
import org.neo4j.shaded.lucene9.queryparser.flexible.messages.MessageImpl;
import org.neo4j.shaded.lucene9.queryparser.flexible.standard.builders.StandardQueryBuilder;
import org.neo4j.shaded.lucene9.search.BooleanClause;
import org.neo4j.shaded.lucene9.search.BooleanQuery;
import org.neo4j.shaded.lucene9.search.IndexSearcher;
import org.neo4j.shaded.lucene9.search.Query;

public class AnyQueryNodeBuilder
implements StandardQueryBuilder {
    @Override
    public BooleanQuery build(QueryNode queryNode) throws QueryNodeException {
        AnyQueryNode andNode = (AnyQueryNode)queryNode;
        BooleanQuery.Builder bQuery = new BooleanQuery.Builder();
        List<QueryNode> children = andNode.getChildren();
        if (children != null) {
            for (QueryNode child : children) {
                Object obj = child.getTag(QueryTreeBuilder.QUERY_TREE_BUILDER_TAGID);
                if (obj == null) continue;
                Query query = (Query)obj;
                try {
                    bQuery.add(query, BooleanClause.Occur.SHOULD);
                }
                catch (IndexSearcher.TooManyClauses ex) {
                    throw new QueryNodeException(new MessageImpl(QueryParserMessages.EMPTY_MESSAGE), (Throwable)ex);
                }
            }
        }
        bQuery.setMinimumNumberShouldMatch(andNode.getMinimumMatchingElements());
        return bQuery.build();
    }
}

