/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.queryparser.flexible.standard.builders;

import org.neo4j.shaded.lucene9.index.Term;
import org.neo4j.shaded.lucene9.queryparser.flexible.core.QueryNodeException;
import org.neo4j.shaded.lucene9.queryparser.flexible.core.nodes.FuzzyQueryNode;
import org.neo4j.shaded.lucene9.queryparser.flexible.core.nodes.QueryNode;
import org.neo4j.shaded.lucene9.queryparser.flexible.standard.builders.StandardQueryBuilder;
import org.neo4j.shaded.lucene9.search.FuzzyQuery;

public class FuzzyQueryNodeBuilder
implements StandardQueryBuilder {
    @Override
    public FuzzyQuery build(QueryNode queryNode) throws QueryNodeException {
        FuzzyQueryNode fuzzyNode = (FuzzyQueryNode)queryNode;
        String text = fuzzyNode.getTextAsString();
        int numEdits = FuzzyQuery.floatToEdits(fuzzyNode.getSimilarity(), text.codePointCount(0, text.length()));
        return new FuzzyQuery(new Term(fuzzyNode.getFieldAsString(), fuzzyNode.getTextAsString()), numEdits, fuzzyNode.getPrefixLength());
    }
}

