/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.queryparser.flexible.standard.builders;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.neo4j.shaded.lucene9.index.Term;
import org.neo4j.shaded.lucene9.queryparser.flexible.core.QueryNodeException;
import org.neo4j.shaded.lucene9.queryparser.flexible.core.builders.QueryTreeBuilder;
import org.neo4j.shaded.lucene9.queryparser.flexible.core.nodes.FieldQueryNode;
import org.neo4j.shaded.lucene9.queryparser.flexible.core.nodes.QueryNode;
import org.neo4j.shaded.lucene9.queryparser.flexible.standard.builders.StandardQueryBuilder;
import org.neo4j.shaded.lucene9.queryparser.flexible.standard.nodes.MultiPhraseQueryNode;
import org.neo4j.shaded.lucene9.search.MultiPhraseQuery;
import org.neo4j.shaded.lucene9.search.TermQuery;

public class MultiPhraseQueryNodeBuilder
implements StandardQueryBuilder {
    @Override
    public MultiPhraseQuery build(QueryNode queryNode) throws QueryNodeException {
        MultiPhraseQueryNode phraseNode = (MultiPhraseQueryNode)queryNode;
        MultiPhraseQuery.Builder phraseQueryBuilder = new MultiPhraseQuery.Builder();
        List<QueryNode> children = phraseNode.getChildren();
        if (children != null) {
            TreeMap<Integer, LinkedList<Term>> positionTermMap = new TreeMap<Integer, LinkedList<Term>>();
            for (QueryNode queryNode2 : children) {
                FieldQueryNode termNode = (FieldQueryNode)queryNode2;
                TermQuery termQuery = (TermQuery)termNode.getTag(QueryTreeBuilder.QUERY_TREE_BUILDER_TAGID);
                LinkedList<Term> termList = (LinkedList<Term>)positionTermMap.get(termNode.getPositionIncrement());
                if (termList == null) {
                    termList = new LinkedList<Term>();
                    positionTermMap.put(termNode.getPositionIncrement(), termList);
                }
                termList.add(termQuery.getTerm());
            }
            for (Map.Entry entry : positionTermMap.entrySet()) {
                List termList = (List)entry.getValue();
                phraseQueryBuilder.add(termList.toArray(new Term[termList.size()]), (Integer)entry.getKey());
            }
        }
        return phraseQueryBuilder.build();
    }
}

