/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.queryparser.flexible.standard.builders;

import org.neo4j.shaded.lucene9.document.DoublePoint;
import org.neo4j.shaded.lucene9.document.FloatPoint;
import org.neo4j.shaded.lucene9.document.IntPoint;
import org.neo4j.shaded.lucene9.document.LongPoint;
import org.neo4j.shaded.lucene9.queryparser.flexible.core.QueryNodeException;
import org.neo4j.shaded.lucene9.queryparser.flexible.core.messages.QueryParserMessages;
import org.neo4j.shaded.lucene9.queryparser.flexible.core.nodes.QueryNode;
import org.neo4j.shaded.lucene9.queryparser.flexible.core.util.StringUtils;
import org.neo4j.shaded.lucene9.queryparser.flexible.messages.MessageImpl;
import org.neo4j.shaded.lucene9.queryparser.flexible.standard.builders.StandardQueryBuilder;
import org.neo4j.shaded.lucene9.queryparser.flexible.standard.config.PointsConfig;
import org.neo4j.shaded.lucene9.queryparser.flexible.standard.nodes.PointQueryNode;
import org.neo4j.shaded.lucene9.queryparser.flexible.standard.nodes.PointRangeQueryNode;
import org.neo4j.shaded.lucene9.search.Query;

public class PointRangeQueryNodeBuilder
implements StandardQueryBuilder {
    @Override
    public Query build(QueryNode queryNode) throws QueryNodeException {
        PointRangeQueryNode numericRangeNode = (PointRangeQueryNode)queryNode;
        PointQueryNode lowerNumericNode = (PointQueryNode)numericRangeNode.getLowerBound();
        PointQueryNode upperNumericNode = (PointQueryNode)numericRangeNode.getUpperBound();
        Number lowerNumber = lowerNumericNode.getValue();
        Number upperNumber = upperNumericNode.getValue();
        PointsConfig pointsConfig = numericRangeNode.getPointsConfig();
        Class<? extends Number> numberType = pointsConfig.getType();
        String field = StringUtils.toString(numericRangeNode.getField());
        boolean minInclusive = numericRangeNode.isLowerInclusive();
        boolean maxInclusive = numericRangeNode.isUpperInclusive();
        if (Integer.class.equals(numberType)) {
            Integer upper;
            Integer lower = (Integer)lowerNumber;
            if (lower == null) {
                lower = Integer.MIN_VALUE;
            }
            if (!minInclusive) {
                lower = lower + 1;
            }
            if ((upper = (Integer)upperNumber) == null) {
                upper = Integer.MAX_VALUE;
            }
            if (!maxInclusive) {
                upper = upper - 1;
            }
            return IntPoint.newRangeQuery(field, lower, upper);
        }
        if (Long.class.equals(numberType)) {
            Long upper;
            Long lower = (Long)lowerNumber;
            if (lower == null) {
                lower = Long.MIN_VALUE;
            }
            if (!minInclusive) {
                lower = lower + 1L;
            }
            if ((upper = (Long)upperNumber) == null) {
                upper = Long.MAX_VALUE;
            }
            if (!maxInclusive) {
                upper = upper - 1L;
            }
            return LongPoint.newRangeQuery(field, lower, upper);
        }
        if (Float.class.equals(numberType)) {
            Float upper;
            Float lower = (Float)lowerNumber;
            if (lower == null) {
                lower = Float.valueOf(Float.NEGATIVE_INFINITY);
            }
            if (!minInclusive) {
                lower = Float.valueOf(Math.nextUp(lower.floatValue()));
            }
            if ((upper = (Float)upperNumber) == null) {
                upper = Float.valueOf(Float.POSITIVE_INFINITY);
            }
            if (!maxInclusive) {
                upper = Float.valueOf(Math.nextDown(upper.floatValue()));
            }
            return FloatPoint.newRangeQuery(field, lower.floatValue(), upper.floatValue());
        }
        if (Double.class.equals(numberType)) {
            Double upper;
            Double lower = (Double)lowerNumber;
            if (lower == null) {
                lower = Double.NEGATIVE_INFINITY;
            }
            if (!minInclusive) {
                lower = Math.nextUp(lower);
            }
            if ((upper = (Double)upperNumber) == null) {
                upper = Double.POSITIVE_INFINITY;
            }
            if (!maxInclusive) {
                upper = Math.nextDown(upper);
            }
            return DoublePoint.newRangeQuery(field, lower, upper);
        }
        throw new QueryNodeException(new MessageImpl(QueryParserMessages.UNSUPPORTED_NUMERIC_DATA_TYPE, numberType));
    }
}

