/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.queryparser.flexible.standard.nodes.intervalfn;

import java.util.Locale;
import java.util.Objects;
import org.neo4j.shaded.lucene9.analysis.Analyzer;
import org.neo4j.shaded.lucene9.queries.intervals.Intervals;
import org.neo4j.shaded.lucene9.queries.intervals.IntervalsSource;
import org.neo4j.shaded.lucene9.queryparser.flexible.standard.nodes.intervalfn.IntervalFunction;

public class NonOverlapping
extends IntervalFunction {
    private final IntervalFunction minuend;
    private final IntervalFunction subtrahend;

    public NonOverlapping(IntervalFunction minuend, IntervalFunction subtrahend) {
        this.minuend = Objects.requireNonNull(minuend);
        this.subtrahend = Objects.requireNonNull(subtrahend);
    }

    @Override
    public IntervalsSource toIntervalSource(String field, Analyzer analyzer) {
        return Intervals.nonOverlapping((IntervalsSource)this.minuend.toIntervalSource(field, analyzer), (IntervalsSource)this.subtrahend.toIntervalSource(field, analyzer));
    }

    @Override
    public String toString() {
        return String.format(Locale.ROOT, "fn:nonOverlapping(%s %s)", this.minuend, this.subtrahend);
    }
}

