/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.queryparser.surround.query;

import java.io.IOException;
import org.neo4j.shaded.lucene9.index.IndexReader;
import org.neo4j.shaded.lucene9.index.MultiTerms;
import org.neo4j.shaded.lucene9.index.Term;
import org.neo4j.shaded.lucene9.index.Terms;
import org.neo4j.shaded.lucene9.index.TermsEnum;
import org.neo4j.shaded.lucene9.queryparser.surround.query.SimpleTerm;
import org.neo4j.shaded.lucene9.search.PrefixQuery;
import org.neo4j.shaded.lucene9.util.BytesRef;
import org.neo4j.shaded.lucene9.util.automaton.CompiledAutomaton;

public class SrndPrefixQuery
extends SimpleTerm {
    private final CompiledAutomaton compiled;
    private final String prefix;
    private final char truncator;

    public SrndPrefixQuery(String prefix, boolean quoted, char truncator) {
        super(quoted);
        this.prefix = prefix;
        this.compiled = new CompiledAutomaton(PrefixQuery.toAutomaton(new BytesRef(prefix)), true, true, 10000, true);
        this.truncator = truncator;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public char getSuffixOperator() {
        return this.truncator;
    }

    @Override
    public String toStringUnquoted() {
        return this.getPrefix();
    }

    @Override
    protected void suffixToString(StringBuilder r) {
        r.append(this.getSuffixOperator());
    }

    @Override
    public void visitMatchingTerms(IndexReader reader, String fieldName, SimpleTerm.MatchingTermVisitor mtv) throws IOException {
        Terms terms = MultiTerms.getTerms(reader, fieldName);
        if (terms != null) {
            BytesRef br;
            TermsEnum termsEnum = this.compiled.getTermsEnum(terms);
            while ((br = termsEnum.next()) != null) {
                mtv.visitMatchingTerm(new Term(fieldName, BytesRef.deepCopyOf(br)));
            }
        }
    }
}

