/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.neo4j.shaded.lucene9.search.BulkScorer;
import org.neo4j.shaded.lucene9.search.DocIdSetIterator;
import org.neo4j.shaded.lucene9.search.LeafCollector;
import org.neo4j.shaded.lucene9.search.Scorable;
import org.neo4j.shaded.lucene9.search.Scorer;
import org.neo4j.shaded.lucene9.util.Bits;
import org.neo4j.shaded.lucene9.util.MathUtil;

final class BlockMaxConjunctionBulkScorer
extends BulkScorer {
    private final Scorer[] scorers;
    private final DocIdSetIterator[] iterators;
    private final DocIdSetIterator lead1;
    private final DocIdSetIterator lead2;
    private final Scorer scorer1;
    private final Scorer scorer2;
    private final DocAndScore scorable = new DocAndScore();
    private final double[] sumOfOtherClauses;
    private final int maxDoc;

    BlockMaxConjunctionBulkScorer(int maxDoc, List<Scorer> scorers) throws IOException {
        if (scorers.size() <= 1) {
            throw new IllegalArgumentException("Expected 2 or more scorers, got " + scorers.size());
        }
        this.scorers = (Scorer[])scorers.toArray(Scorer[]::new);
        Arrays.sort(this.scorers, Comparator.comparingLong(scorer -> scorer.iterator().cost()));
        this.iterators = (DocIdSetIterator[])Arrays.stream(this.scorers).map(Scorer::iterator).toArray(DocIdSetIterator[]::new);
        this.lead1 = this.iterators[0];
        this.lead2 = this.iterators[1];
        this.scorer1 = this.scorers[0];
        this.scorer2 = this.scorers[1];
        this.sumOfOtherClauses = new double[this.scorers.length];
        for (int i = 0; i < this.sumOfOtherClauses.length; ++i) {
            this.sumOfOtherClauses[i] = Double.POSITIVE_INFINITY;
        }
        this.maxDoc = maxDoc;
    }

    private float computeMaxScore(int windowMin, int windowMax) throws IOException {
        int i;
        for (int i2 = 0; i2 < this.scorers.length; ++i2) {
            this.scorers[i2].advanceShallow(windowMin);
        }
        double maxWindowScore = 0.0;
        for (i = 0; i < this.scorers.length; ++i) {
            float maxClauseScore = this.scorers[i].getMaxScore(windowMax);
            this.sumOfOtherClauses[i] = maxClauseScore;
            maxWindowScore += (double)maxClauseScore;
        }
        for (i = this.sumOfOtherClauses.length - 2; i >= 0; --i) {
            int n = i;
            this.sumOfOtherClauses[n] = this.sumOfOtherClauses[n] + this.sumOfOtherClauses[i + 1];
        }
        return (float)maxWindowScore;
    }

    @Override
    public int score(LeafCollector collector, Bits acceptDocs, int min, int max) throws IOException {
        collector.setScorer(this.scorable);
        int windowMin = Math.max(this.lead1.docID(), min);
        while (windowMin < max) {
            int windowMax = Math.min(this.scorers[0].advanceShallow(windowMin), max - 1);
            float maxWindowScore = Float.POSITIVE_INFINITY;
            if (0.0f < this.scorable.minCompetitiveScore) {
                maxWindowScore = this.computeMaxScore(windowMin, windowMax);
            }
            this.scoreWindow(collector, acceptDocs, windowMin, windowMax + 1, maxWindowScore);
            windowMin = Math.max(this.lead1.docID(), windowMax + 1);
        }
        return windowMin >= this.maxDoc ? Integer.MAX_VALUE : windowMin;
    }

    private void scoreWindow(LeafCollector collector, Bits acceptDocs, int min, int max, float maxWindowScore) throws IOException {
        if (maxWindowScore < this.scorable.minCompetitiveScore) {
            return;
        }
        if (this.lead1.docID() < min) {
            this.lead1.advance(min);
        }
        double sumOfOtherMaxScoresAt1 = this.sumOfOtherClauses[1];
        int doc = this.lead1.docID();
        block0: while (doc < max) {
            int next;
            if (acceptDocs != null && !acceptDocs.get(doc)) {
                doc = this.lead1.nextDoc();
                continue;
            }
            boolean hasMinCompetitiveScore = this.scorable.minCompetitiveScore > 0.0f;
            double currentScore = hasMinCompetitiveScore ? (double)this.scorer1.score() : 0.0;
            if (hasMinCompetitiveScore && (float)MathUtil.sumUpperBound(currentScore + sumOfOtherMaxScoresAt1, this.scorers.length) < this.scorable.minCompetitiveScore) {
                doc = this.lead1.nextDoc();
                continue;
            }
            if (this.lead2.docID() < doc && (next = this.lead2.advance(doc)) != doc) {
                doc = this.lead1.advance(next);
                continue;
            }
            assert (this.lead2.docID() == doc);
            if (hasMinCompetitiveScore) {
                currentScore += (double)this.scorer2.score();
            }
            for (int i = 2; i < this.iterators.length; ++i) {
                int next2;
                if (hasMinCompetitiveScore && (float)MathUtil.sumUpperBound(currentScore + this.sumOfOtherClauses[i], this.scorers.length) < this.scorable.minCompetitiveScore) {
                    doc = this.lead1.nextDoc();
                    continue block0;
                }
                if (this.iterators[i].docID() < doc && (next2 = this.iterators[i].advance(doc)) != doc) {
                    doc = this.lead1.advance(next2);
                    continue block0;
                }
                assert (this.iterators[i].docID() == doc);
                if (!hasMinCompetitiveScore) continue;
                currentScore += (double)this.scorers[i].score();
            }
            if (!hasMinCompetitiveScore) {
                for (Scorer scorer : this.scorers) {
                    currentScore += (double)scorer.score();
                }
            }
            this.scorable.doc = doc;
            this.scorable.score = (float)currentScore;
            collector.collect(doc);
            if (maxWindowScore < this.scorable.minCompetitiveScore) {
                return;
            }
            doc = this.lead1.nextDoc();
        }
    }

    @Override
    public long cost() {
        return this.lead1.cost();
    }

    private static class DocAndScore
    extends Scorable {
        int doc = -1;
        float score;
        float minCompetitiveScore;

        private DocAndScore() {
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public float score() throws IOException {
            return this.score;
        }

        @Override
        public void setMinCompetitiveScore(float minScore) throws IOException {
            this.minCompetitiveScore = minScore;
        }
    }
}

