/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.search;

import java.io.IOException;
import org.neo4j.shaded.lucene9.index.LeafReaderContext;
import org.neo4j.shaded.lucene9.search.Explanation;
import org.neo4j.shaded.lucene9.search.Query;
import org.neo4j.shaded.lucene9.search.Scorer;
import org.neo4j.shaded.lucene9.search.TwoPhaseIterator;
import org.neo4j.shaded.lucene9.search.Weight;

public abstract class ConstantScoreWeight
extends Weight {
    private final float score;

    protected ConstantScoreWeight(Query query, float score) {
        super(query);
        this.score = score;
    }

    protected final float score() {
        return this.score;
    }

    @Override
    public Explanation explain(LeafReaderContext context, int doc) throws IOException {
        boolean exists;
        Scorer s = this.scorer(context);
        if (s == null) {
            exists = false;
        } else {
            TwoPhaseIterator twoPhase = s.twoPhaseIterator();
            if (twoPhase == null) {
                exists = s.iterator().advance(doc) == doc;
            } else {
                boolean bl = exists = twoPhase.approximation().advance(doc) == doc && twoPhase.matches();
            }
        }
        if (exists) {
            return Explanation.match((Number)Float.valueOf(this.score), this.getQuery().toString() + (String)(this.score == 1.0f ? "" : "^" + this.score), new Explanation[0]);
        }
        return Explanation.noMatch(this.getQuery().toString() + " doesn't match id " + doc, new Explanation[0]);
    }
}

