/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.search;

import java.io.IOException;
import org.neo4j.shaded.lucene9.index.BinaryDocValues;
import org.neo4j.shaded.lucene9.index.DocValues;
import org.neo4j.shaded.lucene9.index.LeafReaderContext;
import org.neo4j.shaded.lucene9.search.LeafFieldComparator;
import org.neo4j.shaded.lucene9.search.Scorable;
import org.neo4j.shaded.lucene9.search.ScoreCachingWrappingScorer;
import org.neo4j.shaded.lucene9.util.BytesRef;
import org.neo4j.shaded.lucene9.util.BytesRefBuilder;

public abstract class FieldComparator<T> {
    public abstract int compare(int var1, int var2);

    public abstract void setTopValue(T var1);

    public abstract T value(int var1);

    public abstract LeafFieldComparator getLeafComparator(LeafReaderContext var1) throws IOException;

    public int compareValues(T first, T second) {
        if (first == null) {
            if (second == null) {
                return 0;
            }
            return -1;
        }
        if (second == null) {
            return 1;
        }
        return ((Comparable)first).compareTo(second);
    }

    public void setSingleSort() {
    }

    public void disableSkipping() {
    }

    public static class TermValComparator
    extends FieldComparator<BytesRef>
    implements LeafFieldComparator {
        private final BytesRef[] values;
        private final BytesRefBuilder[] tempBRs;
        private BinaryDocValues docTerms;
        private final String field;
        private BytesRef bottom;
        private BytesRef topValue;
        private final int missingSortCmp;

        public TermValComparator(int numHits, String field, boolean sortMissingLast) {
            this.values = new BytesRef[numHits];
            this.tempBRs = new BytesRefBuilder[numHits];
            this.field = field;
            this.missingSortCmp = sortMissingLast ? 1 : -1;
        }

        private BytesRef getValueForDoc(int doc) throws IOException {
            if (this.docTerms.advanceExact(doc)) {
                return this.docTerms.binaryValue();
            }
            return null;
        }

        @Override
        public int compare(int slot1, int slot2) {
            BytesRef val1 = this.values[slot1];
            BytesRef val2 = this.values[slot2];
            return this.compareValues(val1, val2);
        }

        @Override
        public int compareBottom(int doc) throws IOException {
            BytesRef comparableBytes = this.getValueForDoc(doc);
            return this.compareValues(this.bottom, comparableBytes);
        }

        @Override
        public void copy(int slot, int doc) throws IOException {
            BytesRef comparableBytes = this.getValueForDoc(doc);
            if (comparableBytes == null) {
                this.values[slot] = null;
            } else {
                if (this.tempBRs[slot] == null) {
                    this.tempBRs[slot] = new BytesRefBuilder();
                }
                this.tempBRs[slot].copyBytes(comparableBytes);
                this.values[slot] = this.tempBRs[slot].get();
            }
        }

        protected BinaryDocValues getBinaryDocValues(LeafReaderContext context, String field) throws IOException {
            return DocValues.getBinary(context.reader(), field);
        }

        @Override
        public LeafFieldComparator getLeafComparator(LeafReaderContext context) throws IOException {
            this.docTerms = this.getBinaryDocValues(context, this.field);
            return this;
        }

        @Override
        public void setBottom(int bottom) {
            this.bottom = this.values[bottom];
        }

        @Override
        public void setTopValue(BytesRef value) {
            this.topValue = value;
        }

        @Override
        public BytesRef value(int slot) {
            return this.values[slot];
        }

        @Override
        public int compareValues(BytesRef val1, BytesRef val2) {
            if (val1 == null) {
                if (val2 == null) {
                    return 0;
                }
                return this.missingSortCmp;
            }
            if (val2 == null) {
                return -this.missingSortCmp;
            }
            return val1.compareTo(val2);
        }

        @Override
        public int compareTop(int doc) throws IOException {
            return this.compareValues(this.topValue, this.getValueForDoc(doc));
        }

        @Override
        public void setScorer(Scorable scorer) {
        }
    }

    public static final class RelevanceComparator
    extends FieldComparator<Float>
    implements LeafFieldComparator {
        private final float[] scores;
        private float bottom;
        private Scorable scorer;
        private float topValue;

        public RelevanceComparator(int numHits) {
            this.scores = new float[numHits];
        }

        @Override
        public int compare(int slot1, int slot2) {
            return Float.compare(this.scores[slot2], this.scores[slot1]);
        }

        @Override
        public int compareBottom(int doc) throws IOException {
            float score = this.scorer.score();
            assert (!Float.isNaN(score));
            return Float.compare(score, this.bottom);
        }

        @Override
        public void copy(int slot, int doc) throws IOException {
            this.scores[slot] = this.scorer.score();
            assert (!Float.isNaN(this.scores[slot]));
        }

        @Override
        public LeafFieldComparator getLeafComparator(LeafReaderContext context) {
            return this;
        }

        @Override
        public void setBottom(int bottom) {
            this.bottom = this.scores[bottom];
        }

        @Override
        public void setTopValue(Float value) {
            this.topValue = value.floatValue();
        }

        @Override
        public void setScorer(Scorable scorer) {
            this.scorer = ScoreCachingWrappingScorer.wrap(scorer);
        }

        @Override
        public Float value(int slot) {
            return Float.valueOf(this.scores[slot]);
        }

        @Override
        public int compareValues(Float first, Float second) {
            return second.compareTo(first);
        }

        @Override
        public int compareTop(int doc) throws IOException {
            float docValue = this.scorer.score();
            assert (!Float.isNaN(docValue));
            return Float.compare(docValue, this.topValue);
        }
    }
}

