/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.search;

import java.io.IOException;
import java.util.function.Supplier;
import org.neo4j.shaded.lucene9.index.ImpactsEnum;
import org.neo4j.shaded.lucene9.index.PostingsEnum;
import org.neo4j.shaded.lucene9.index.Term;
import org.neo4j.shaded.lucene9.index.TermState;
import org.neo4j.shaded.lucene9.index.Terms;
import org.neo4j.shaded.lucene9.index.TermsEnum;
import org.neo4j.shaded.lucene9.search.BoostAttribute;
import org.neo4j.shaded.lucene9.search.FuzzyAutomatonBuilder;
import org.neo4j.shaded.lucene9.search.MaxNonCompetitiveBoostAttribute;
import org.neo4j.shaded.lucene9.util.Attribute;
import org.neo4j.shaded.lucene9.util.AttributeImpl;
import org.neo4j.shaded.lucene9.util.AttributeReflector;
import org.neo4j.shaded.lucene9.util.AttributeSource;
import org.neo4j.shaded.lucene9.util.BytesRef;
import org.neo4j.shaded.lucene9.util.BytesRefBuilder;
import org.neo4j.shaded.lucene9.util.UnicodeUtil;
import org.neo4j.shaded.lucene9.util.automaton.CompiledAutomaton;

public final class FuzzyTermsEnum
extends TermsEnum {
    private TermsEnum actualEnum;
    private final AttributeSource atts;
    private final BoostAttribute boostAtt;
    private final MaxNonCompetitiveBoostAttribute maxBoostAtt;
    private final CompiledAutomaton[] automata;
    private final Terms terms;
    private final int termLength;
    private final Term term;
    private float bottom;
    private BytesRef bottomTerm;
    private BytesRef queuedBottom;
    private int maxEdits;

    public FuzzyTermsEnum(Terms terms, Term term, int maxEdits, int prefixLength, boolean transpositions) throws IOException {
        this(terms, new AttributeSource(), term, () -> new FuzzyAutomatonBuilder(term.text(), maxEdits, prefixLength, transpositions));
    }

    FuzzyTermsEnum(Terms terms, AttributeSource atts, Term term, int maxEdits, int prefixLength, boolean transpositions) throws IOException {
        this(terms, atts, term, () -> new FuzzyAutomatonBuilder(term.text(), maxEdits, prefixLength, transpositions));
    }

    private FuzzyTermsEnum(Terms terms, AttributeSource atts, Term term, Supplier<FuzzyAutomatonBuilder> automatonBuilder) throws IOException {
        this.terms = terms;
        this.atts = atts;
        this.term = term;
        this.maxBoostAtt = atts.addAttribute(MaxNonCompetitiveBoostAttribute.class);
        this.boostAtt = atts.addAttribute(BoostAttribute.class);
        atts.addAttributeImpl(new AutomatonAttributeImpl());
        AutomatonAttribute aa = atts.addAttribute(AutomatonAttribute.class);
        aa.init(automatonBuilder);
        this.automata = aa.getAutomata();
        this.termLength = aa.getTermLength();
        this.maxEdits = this.automata.length - 1;
        this.bottom = this.maxBoostAtt.getMaxNonCompetitiveBoost();
        this.bottomTerm = this.maxBoostAtt.getCompetitiveTerm();
        this.bottomChanged(null);
    }

    public void setMaxNonCompetitiveBoost(float boost) {
        this.maxBoostAtt.setMaxNonCompetitiveBoost(boost);
    }

    public float getBoost() {
        return this.boostAtt.getBoost();
    }

    private TermsEnum getAutomatonEnum(int editDistance, BytesRef lastTerm) throws IOException {
        assert (editDistance < this.automata.length);
        CompiledAutomaton compiled = this.automata[editDistance];
        BytesRef initialSeekTerm = lastTerm == null ? null : compiled.floor(lastTerm, new BytesRefBuilder());
        return this.terms.intersect(compiled, initialSeekTerm);
    }

    private void bottomChanged(BytesRef lastTerm) throws IOException {
        float maxBoost;
        boolean termAfter;
        int oldMaxEdits = this.maxEdits;
        boolean bl = termAfter = this.bottomTerm == null || lastTerm != null && lastTerm.compareTo(this.bottomTerm) >= 0;
        while (this.maxEdits > 0 && !(this.bottom < (maxBoost = 1.0f - (float)this.maxEdits / (float)this.termLength)) && (this.bottom != maxBoost || termAfter)) {
            --this.maxEdits;
        }
        if (oldMaxEdits != this.maxEdits || lastTerm == null) {
            this.actualEnum = this.getAutomatonEnum(this.maxEdits, lastTerm);
        }
    }

    @Override
    public BytesRef next() throws IOException {
        int ed;
        BytesRef term;
        if (this.queuedBottom != null) {
            this.bottomChanged(this.queuedBottom);
            this.queuedBottom = null;
        }
        if ((term = this.actualEnum.next()) == null) {
            return null;
        }
        for (ed = this.maxEdits; ed > 0 && this.matches(term, ed - 1); --ed) {
        }
        if (ed == 0) {
            this.boostAtt.setBoost(1.0f);
        } else {
            int codePointCount = UnicodeUtil.codePointCount(term);
            int minTermLength = Math.min(codePointCount, this.termLength);
            float similarity = 1.0f - (float)ed / (float)minTermLength;
            this.boostAtt.setBoost(similarity);
        }
        float bottom = this.maxBoostAtt.getMaxNonCompetitiveBoost();
        BytesRef bottomTerm = this.maxBoostAtt.getCompetitiveTerm();
        if (bottom != this.bottom || bottomTerm != this.bottomTerm) {
            this.bottom = bottom;
            this.bottomTerm = bottomTerm;
            this.queuedBottom = BytesRef.deepCopyOf(term);
        }
        return term;
    }

    private boolean matches(BytesRef termIn, int k) {
        return k == 0 ? termIn.equals(this.term.bytes()) : this.automata[k].runAutomaton.run(termIn.bytes, termIn.offset, termIn.length);
    }

    @Override
    public int docFreq() throws IOException {
        return this.actualEnum.docFreq();
    }

    @Override
    public long totalTermFreq() throws IOException {
        return this.actualEnum.totalTermFreq();
    }

    @Override
    public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
        return this.actualEnum.postings(reuse, flags);
    }

    @Override
    public ImpactsEnum impacts(int flags) throws IOException {
        return this.actualEnum.impacts(flags);
    }

    @Override
    public void seekExact(BytesRef term, TermState state) throws IOException {
        this.actualEnum.seekExact(term, state);
    }

    @Override
    public TermState termState() throws IOException {
        return this.actualEnum.termState();
    }

    @Override
    public long ord() throws IOException {
        return this.actualEnum.ord();
    }

    @Override
    public AttributeSource attributes() {
        return this.atts;
    }

    @Override
    public boolean seekExact(BytesRef text) throws IOException {
        return this.actualEnum.seekExact(text);
    }

    @Override
    public TermsEnum.SeekStatus seekCeil(BytesRef text) throws IOException {
        return this.actualEnum.seekCeil(text);
    }

    @Override
    public void seekExact(long ord) throws IOException {
        this.actualEnum.seekExact(ord);
    }

    @Override
    public BytesRef term() throws IOException {
        return this.actualEnum.term();
    }

    private static class AutomatonAttributeImpl
    extends AttributeImpl
    implements AutomatonAttribute {
        private CompiledAutomaton[] automata;
        private int termLength;

        private AutomatonAttributeImpl() {
        }

        @Override
        public CompiledAutomaton[] getAutomata() {
            return this.automata;
        }

        @Override
        public int getTermLength() {
            return this.termLength;
        }

        @Override
        public void init(Supplier<FuzzyAutomatonBuilder> supplier) {
            if (this.automata != null) {
                return;
            }
            FuzzyAutomatonBuilder builder = supplier.get();
            this.termLength = builder.getTermLength();
            this.automata = builder.buildAutomatonSet();
        }

        @Override
        public void clear() {
            this.automata = null;
        }

        @Override
        public void reflectWith(AttributeReflector reflector) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void copyTo(AttributeImpl target) {
            throw new UnsupportedOperationException();
        }
    }

    private static interface AutomatonAttribute
    extends Attribute {
        public CompiledAutomaton[] getAutomata();

        public int getTermLength();

        public void init(Supplier<FuzzyAutomatonBuilder> var1);
    }

    public static class FuzzyTermsException
    extends RuntimeException {
        FuzzyTermsException(String term, Throwable cause) {
            super("Term too complex: " + term, cause);
        }
    }
}

